function y = intCoseno(x,deltaS);
%
% y = intCoseno(x,deltaS);
%
% Funcin que calcula la integral del pulso de tipo coseno (1+cos(w))
% con un perodo limitado entre +/- deltaS desde x a infinito
% 
%
%--------------------------------------------------------------------------
%         Autor: Marcelino Lzaro
%      Creacin: diciembre 2014
% Actualizacin: diciembre 2014
%--------------------------------------------------------------------------
%

y = ones(size(x));

v = find(abs(x)<deltaS);
y(v) = 0.5 - x(v)/2/deltaS  - sin(pi*x(v)/deltaS)/(2*pi) ; 

v = find(x>=deltaS);
y(v) = 0;