function [W,evoRiesgo,paso]=mlpMg_BayesMirror(x,y,W,tAct,parametros,tipoFDP,Niter,paso);
%
%  [W,bRisk,step]=mlpMg_BayesMirror(x,y,W,tAct,pBay,tFDP,Niter,step)
%
%  Function that trains a MLP network with M hidden layers by minimizing
%  an estimation of the Bayesian risk (based on Parzen windows estimation)
%  by means of gradient descent with an adaptive step size. 
%  Mirror windows are considered for the two classes and costs per class 
%  can be specified.
%
%     x : input patterns (Nd x Np)
%     y : output labels (1 x Np)
%     W : cell array containing the weights of the hidden layers and the 
%         output layer: 1 x (M+1)
%         - layer k : Nk x (Nv +1), with Nv being the number of neurons of the
%                     previous layer and Nk the number of neurons of layer k
%  tAct : parameter defining the activation functions for the neurons of 
%         each layer in the network. It is a vector of dimension M+1, with 
%         the values defining the activations for the M hidden layer and the
%         output layer. For each layer activations are defined as follows:
%         - 0: linear
%         - 1: tanh
%         - 2: logistic
%         - 3: rectified linear unit (ReLU)
%
%  pBay : Bayesian parameters for the training of the network
%            - pBay(1): P0 (probability of class -1)
%            - pBay(2): C0 (cost of deciding +1 when hypothesis -1 is true)
%            - pBay(3): C1 (cost of deciding -1 when hypothesis +1 is true)
%  tFDP : parameters of the Parzen window that is used to estimate the risk
%
%    tFDP(1) defines the kind of PDF and the remaining elements are parameters 
%    See the help of function fdpGeneralN for details
%
% Niter : number of iterations of gradient
%  step : parameters of the adaptive step size for gradiente descent [mu,muCrec,muDec]
%         - mu: step size
%         - muCrec: increasing factor if risk decreases in the iteration
%         - muDec: decreasing factor if risk increases in the iteration
%
%  bRisk: evolution of the Bayesian risk during training: 1 + (Niter+1)
%
%       Where Nd and Np are the number of characteristics of a pattern 
%       (dimension of the input space) and the number of patterns of the 
%       train set, respectively.
%
%--------------------------------------------------------------------------
%        Author: Marcelino Lzaro
%      Creation: December 2016
%   Last update: January 2018
%--------------------------------------------------------------------------

%  [W,evoRiesgo,paso]=mlpMg_BayesMirror(x,y,W,tAct,pBay,tFDP,Niter,paso)
%
%  Funcin que entrena un MLP de M capas ocultas minimizando mediante
%  descenso de gradiente la estima del riesgo de Bayes utilizando 
%  ventanas de Parzen
%
%     x : patrones de entrada (Ne x Np)
%     y : patrones de salida (Ns x Np)
%     W : cell array con los pesos de las capas ocultas y de salida, 1 x (M+1)
%         capa k : Nk x (Nv +1), siendo Nv en nmero de neuronas de la
%         capa anterior, y Nk el de la capa k
%  tAct : parmetro que define el tipo de funciones de activacin de cada
%         una de las capas de la red. Es un vector de dimensin M+1, con 
%         los valores correspondientes a las M capas ocultas y a la capa 
%         de salida. Para cada capa se define la activacin como
%         - 0: lineal
%         - 1: tanh
%         - 2: logistic
%         - 3: lineal rectificada (ReLU)
%
%  pBay : parmetros del algoritmo de entrenamiento basado en Bayes
%            - pBay(1): P0 (probabilidad clase -1)
%            - pBay(2): C0 (coste decidir +1 cuando hipotesis es -1)
%            - pBay(3): C1 (coste decidir -1 cuando hipotesis es +1)
%  tFDP : tipo de FDP base para el estimador de Parzen
%
%    tFDP(1) define el tipo de FDP y el resto son parmetros 
%    Vea la ayuda de la funcin fdpGeneralN para ver los tipos disponibles
%
% Niter : nmero de iteraciones de gradiente
%  paso : parmetros para la adaptacin por gradiente [mu,muCrec,muDec]
%         - mu: paso de adaptacin
%         - muCrec: factor por el que se multiplica a mu si el coste decrece
%         - muDec: factor por el que se divide a mu si el coste crece
%
%       Donde Ne, Ns y Np son respectivamente el nmero de entradas
% 		el nmero de salidas y el de patrones.
%
%--------------------------------------------------------------------------
%         Autor: Marcelino Lzaro
%      Creacin: diciembre 2016
% Actualizacin: enero 2018
%--------------------------------------------------------------------------


%-----------------------------
% Lectura parmetros Bayes
%-----------------------------
if length(parametros==3)
    Prob0 = parametros(1);
    Prob1 = 1-Prob0;
    C0 = parametros(2);
    C1 = parametros(3);
end
C0t = C0*Prob0;
C1t = C1*Prob1;
%-----------------------------
% Organizacion datos
%-----------------------------
[Ne,Np]=size(x);
[Ns,Np]=size(y);
v=find(y==0);
if length(v)==0
    v=find(y==-1);
end
N0=length(v);
x0=x(:,v);
v=find(y==1);
N1=length(v);
x1=x(:,v);
%-----------------------------
[nada,Ms]=size(W);

if nargin < 4, tAct = [ones(1,Ms-1),0];end
if nargin < 6, Niter = 1000; end
if nargin < 7
    paso=1e-3;		% Parmetro de aprendizaje
end
if length(paso)==1
    mu=paso;
    muCrec=1.05;	% Parmetro de Crecimiento de muc y mus
    muDec=2;		% Parmetro de Decrecimiento de muc y mus
else
    mu=paso(1);
    muCrec=paso(2);
    muDec=paso(3);
end

[Ne,Np]=size(x);
[Ns,Np]=size(y);

ws=W{1,end};

if length(ws(:))== 0
    NnS=[Ne,cell2mat(W),Ns];
    for ko=1:Ms
        %W{1,ko} = sqrt(2/NnS(ko))*randn(NnS(ko+1),NnS(ko)+1);
        W{1,ko} = sqrt(1/NnS(ko))*(2*rand(NnS(ko+1),NnS(ko)+1)-1);
    end
end

evoRiesgo = zeros(1,Niter+1);
[ye,O] = mlpM([x0,x1],W,tAct);
y0=ye(1:N0);
y1=ye(N0+1:end);

auxcoste0=intGeneralN(y0,tipoFDP);
auxcoste1=intGeneralN(-y1,tipoFDP);
evoRiesgo(1)=C0t*mean(auxcoste0(:))+C1t*mean(auxcoste1(:));

coste = evoRiesgo(1);

Wn=cell(1,Ms);
dW=cell(1,Ms);
for kiter=1:Niter
    %----------------------------------------------------------------------
    % Clculo del gradiente
    %----------------------------------------------------------------------
    %dW=adapmlpMb(x,y,W,tAct);
    %----------------------------------------------------------------------
    z0=fdpGeneralN(+ye(1:N0),tipoFDP);
    z1=fdpGeneralN(-ye(N0+1:end),tipoFDP);

    d = [z0*C0t/N0, -z1*C1t/N1];

    if tAct(end) == 1
        d = d .*(1-ye.^2);
    elseif tAct(end) == 2
        d = d .*(ye-ye.^2);
    elseif tAct(end) == 3
        v=find(ye<=0);
        d(v)=0;    
    end
    dW{1,end}=d*transpose([O{1,end};ones(1,Np)]);

    dp=d;
    o=O{1,end};
    for ko=Ms-1:-1:1
        wp=W{1,ko+1};    
        d=transpose(wp(:,1:end-1))*dp;    
        if tAct(ko) == 1
            d=d.*(1-o.^2);
        elseif tAct(ko) == 2
            d=d.*(o-o.^2);
        elseif tAct(ko) == 3
            mascara=o>0;
            d=d.*mascara;
        end
        if ko==1
            o=[x0,x1];
        else
            o=O{1,ko-1};
        end
        dW{1,ko}=d*transpose([o;ones(1,Np)]);
        dp=d;
    end
    %----------------------------------------------------------------------
    %for ko=1:Ms
    %    Wn{1,ko}=W{1,ko}-mu*dW{1,ko};
    %end
    Wn = cellfun(@(b,c)[b-mu*c], W, dW, 'uni',0);
        
    [ye,O] = mlpM([x0,x1],Wn,tAct);
    y0=ye(1:N0);
    y1=ye(N0+1:end);

    auxcoste0=intGeneralN(y0,tipoFDP);
    auxcoste1=intGeneralN(-y1,tipoFDP);
    costen=C0t*mean(auxcoste0(:))+C1t*mean(auxcoste1(:));
    
    if (costen >= coste)
        aumenta=1;        
      
		while aumenta
            % Se va a disminuir mu
			mu = mu / muDec;
            
            %for ko=1:Ms
            %    Wn{1,ko}=W{1,ko}-mu*dW{1,ko};
            %end
            Wn = cellfun(@(b,c)[b-mu*c], W, dW, 'uni',0);
                                   
            [ye,O] = mlpM([x0,x1],Wn,tAct);
            y0=ye(1:N0);
            y1=ye(N0+1:end);

            auxcoste0=intGeneralN(y0,tipoFDP);
            auxcoste1=intGeneralN(-y1,tipoFDP);
            costen=C0t*mean(auxcoste0(:))+C1t*mean(auxcoste1(:));
           
            if ((costen < coste)|(mu<1e-30));
                aumenta = 0;
                if mu < 1e-30
                    disp('mlpMg_BayesMirror - Step size reached the limit...')
                    evoRiesgo(kiter+1:end)=coste;
                    paso=[mu,muCrec,muDec];
                    return
                end
            end
		end  % Del While
	  
	end	% Del If (errn > erra) principal

    mu = mu * muCrec;
    
    W=Wn;    
    
    coste = costen;
    evoRiesgo(kiter+1)=coste;
    
end

paso=[mu,muCrec,muDec];
