load binarydigits.txt -ascii;
Y=binarydigits;
[N D]=size(Y);

% Pick random image i and remove from data set
i=ceil(rand*N);
X=Y(i,:);
Y=Y([1:(i-1),(i+1):N],:);
N=N-1;

% Display image i
subplot(1,2,1);
y=X;
colormap gray;
imagesc(reshape(y',8,8)')
axis square, set(gca,'XTick',0), set(gca,'YTick',0)
xlabel('Random digit');

% Find j, nearest neighbour to i
Ydisp=Y-repmat(X,N,1); % NxD
Ydist2=sum(Ydisp.^2,2);
[mindist2,j]=min(Ydist2);

% Display image j
subplot(1,2,2);
y=Y(j,:);
colormap gray;
imagesc(reshape(y',8,8)')
axis square, set(gca,'XTick',0), set(gca,'YTick',0)
xlabel('Nearest neighbour');

