function plotgauss(mu,S)
% function plotgauss(mu,S)
%
% Plot a 2D Gaussian with axes, two contours and a bunch of samples
% Maintain the current 'hold' plotting state

% We're going to use Tom Minka's lightspeed library here
if ispc
	addpath('..\lightspeed'); % untested, I don't use windows
else
	addpath('../lightspeed');
end

held=ishold; hold on

if size(mu,1)==1
	mu=mu';
end

samples=randnorm(50,mu,[],S);
plot(samples(1,:),samples(2,:),'.m'); % plot faster than scatter
draw_ellipse(mu, S, 'b');
draw_ellipse_axes(mu, 5*S, 'k');
draw_ellipse(mu, 4*S, 'r');

% reinstate hold state if necessary
if ~ishold
	hold off
end
