function [W,b] = leastsquare(X,Y)

% X: J x N matrix of N input vectors with dimension K
% Y: K x N matrix of N target vectors with dimension J
% W: K x J matrix of regression coefficients
% b: J x 1 intercept vector

N = size(X,2);

% Means of X and Y
meanX = mean(X,2); meanY = mean(Y,2);

% Calculate covariance matrix of X:
covX = X*X'/N - meanX*meanX'; % or just covX = cov(X',1)!

% Calculate covariance between Y & X
covYX = Y*X'/N - meanY*meanX';

% use MLDIVIDE(\) or MRDIVIDE(/) when solving linear systems of
% equations, rather than INV
W = covYX/covX; % equivalent to cov(X,Y)*inv(covX)

b = meanY - W*meanX;


