function [Xproj,meanX,V,S] = PCA(X,K)

N = size(X,1);
% Calculate mean and covariance matrix
meanX = mean(X);
covX = cov(X,1);
% SVD to calculate K principal eigenvectors
[V,S] = svds(covX,K);
% Project X onto K principal eigenvectors
Xproj = (X - repmat(meanX,N,1))*V*V' + repmat(meanX,N,1);
