% Visualise the one dimensional Gaussians used on the slides

h=figure(1);
clf; hold on;
set(gcf,'PaperPosition',[2 2 1.5 1.5]);

x=(-8:0.05:8)';

sigma=0.7;
plot(x,exp(-0.5*x.*x/sigma^2)/(sqrt(2*pi)*sigma),'r');

sigma=1;
plot(x,exp(-0.5*x.*x/sigma^2)/(sqrt(2*pi)*sigma),'b');

sigma=2;
plot(x,exp(-0.5*x.*x/sigma^2)/(sqrt(2*pi)*sigma),'m');

print(h, 'onedim.eps', '-depsc');
