% Create some data, 2D input, 1D output
W = [-1 4]; b = 3;
N = 20;
X = randn(size(W,2),N);
Y = W*X + repmat(b,size(W,1),N) + randn(size(W,1),N);

% Perform leastsquares
[Wlsq,bsq] = leastsquare(X,Y)

% plot data and least squares fit
figure
scatter3(X(1,:),X(2,:),Y,20,'ok','filled') % use PLOT3 if you don't
                                           % want big markers, as
                                           % it is much faster
hold on
grid on
v = axis;
Xplot = [v(1) v(1) v(2) v(2); v(3) v(4) v(4) v(3)];
Yplot = Wlsq*Xplot + repmat(b,1,size(Xplot,2));
% shaded patch with colour proportional to 'y'
patch(Xplot(1,:),Xplot(2,:),Yplot,Yplot)
xlabel('x_1','fontsize',12)
ylabel('x_2','fontsize',12)
zlabel('y','fontsize',12,'rotation',0)
title('Least Squares Demo','fontsize',14)

h = colorbar; axes(h)
ylabel('y','fontsize',12,'rotation',0)
hold off
