function englishwelsh(teststring)
% function englishwelsh(teststring)
% 
% Outputs whether test string is English or Welsh with a very naive probability.

alphabet=['a':'z',' '];

% Train some "language models"
Ep=train('english.txt',alphabet);
Wp=train('welsh.txt',alphabet);

f=freqs(teststring,alphabet);

% Work out probability in "obvious" way. Will only work
% for tiny strings because of numerical issues
pE=prod(Ep.^f);
pW=prod(Wp.^f);
probEnglish=1/(1+pW/pE);
fprintf('"Probability" English is %5.5f\n',probEnglish);

% Work out log probability instead. Can exponentiate at end.
lpE=sum(f.*log(Ep));
lpW=sum(f.*log(Wp));
lprobEnglish=-log(1+exp(lpW-lpE));
fprintf('\nLog "probability" English is %5.5f\n',lprobEnglish);
fprintf('or "probability" English is %5.5f\n',exp(lprobEnglish));

