function eigenfacesk(K)
% function eigenfacesk(K)
%
% Specify K and a figure will be produced containing the first K eigenfaces in
% the olivetti data set. In addition a random face will be shown and
% sequentially reconstructed using projections onto the eigenfaces.

more off
load 'faces32x32'
[N D]=size(faces2);
m=32;

M=mean(faces2,1); % Mean face (as column vector)
C=cov(faces2,1);  % Face vector covariance matrix
OPTS.issym=1;
OPTS.isreal=1;
OPTS.tol=eps;
OPTS.disp=0;
[V,S,flag]=eigs(C,K,'LM',OPTS);
if flag
	fprintf('eigs did not converge\n');
end

% Plot layout:
% One row with test image and mean face. One set of rows with eigs. One set of
% rows with reconstructions. Blank rows between each set of images. Have 10
% columns.
cols=10;
rows=3+2*ceil(K/cols);
clf;
subplot(rows,cols,floor(cols/2));
colormap gray;
imagesc(reshape(M',m,m))
axis square, set(gca,'XTick',0), set(gca,'YTick',0)
xlabel('Mean face');

% display first few eigenfaces
for i=1:K
	subplot(rows,cols,2*cols+i);
	y=V(:,i);
	colormap gray;
	imagesc(reshape(y',m,m))
	axis square, set(gca,'XTick',0), set(gca,'YTick',0)
	label=sprintf('%dth eig',i);
	xlabel(label);
end

% pick and draw random face
f=ceil(rand*N);
subplot(rows,cols,floor(cols/2)+1);
colormap gray;
imagesc(reshape(faces2(f,:)',m,m))
axis square, set(gca,'XTick',0), set(gca,'YTick',0)
label=sprintf('Random Face',i);
xlabel(label);

% Reconstruct face using K eigenvectors
R=M;
for i=1:K
	R=R+(faces2(f,:)-M)*V(:,i)*V(:,i)';
	subplot(rows,cols,3*cols+ceil(K/cols)*cols+i);
	colormap gray;
	imagesc(reshape(R',m,m))
	axis square, set(gca,'XTick',0), set(gca,'YTick',0)
	label=sprintf('%dth recon.',i);
	xlabel(label);
end

