% Run PCA on a simple demo with "D=2" and "K=1"
% Used to produce a figure on the slides

h=figure(1);
clf; hold on; axis equal;
set(gcf,'PaperPosition',[2 2 2 2]);

% We're going to use Tom Minka's lightspeed library here
if ispc
	addpath('..\lightspeed'); % untested, I don't use windows
else
	addpath('../lightspeed');
end

% Generate data
R = [1 1;-1 1]/sqrt(2);
X = randnorm(20,[5;3],[],R*[10 0; 0 0.5]*R')'; %from Tom Minka's
                                              %Lightspeed toolbox
% Perform PCA and get projections, eigenvectors, eigenvalues and mean
[Xproj,meanX,V,S] = PCA(X,1);

% Plot demo
hold on
plot(Xproj(:,1),Xproj(:,2),'r')
for i = 1:size(X,1)
  plot([X(i,1)  Xproj(i,1)],[X(i,2)  Xproj(i,2)],'m')
end
plot(Xproj(:,1),Xproj(:,2),'.b')
plot(X(:,1),X(:,2),'xk')
axis equal  
hold off

print(h, 'pcademo.eps', '-depsc');
