function [nsv,alpha,bias,rho,T,Lp]=irwls_nusvc(x,y,ker,nu,par);
%
%
%  This function solves the Support Vector Machine for pattern recognition.
%
%     [nsv,alpha,bias,rho,T,Lp]=irwls_nusvc(x,y,ker,nu,par);
%
% This function solves the SVM using the IRWLS procedure. 
% Parameters:
%
%              x: matrix of input vectors. Each row of x1 represents a d-dimensional vector. 
%                 The number of rows is the number of training samples.
%              y: column vector of lables (-1 or +1). Each row represent the lable of the sample in x.
%              ker: the kernel to be employed. It has to be a string out of: 'linear', 'poly_h', 'poly_i' and 'rbf'.
%                Type help kernel for further information.
%              nu: is the nu parameter in the SVC formulation, rought the
%              fraction of support vector 
%              par: is the parameter of the used kernel. type help kernel for further information.
%
% Outputs:
%
%              nsv: number of support vectors.
%              alpha: the value of the alphas, lagrange multiplier associated with each restriction.
%              bias: the value of the bias.
%              rho: the margin.
%              T: running time.
%              Lp: A vector that show the value of the primal \|w\|^2+C\sum_{i=0}^n \xi_i in each iteration
%               of the algorithm.
%
% Examples:
%
%       with linear kernel:
%               x=[randn(1,50)-3 randn(1,50)+3;randn(1,100)]';
%               y=[-ones(1,50) ones(1,50)]';
%               global rho  % this is for the svcplot to work properly
%               [nsv,alpha,bias,rho]=irwls_nusvc(x,y,'linear',.51);
%               svcplot(x,y,'linear',alpha,bias);
% 
%               W=x'*(alpha.*y);
%               X_test=[randn(1,500)-3 randn(1,500)+3;randn(1,1000)]';
%               Y_test=[-ones(1,500) ones(1,500)]';
%               Output=X_test*W+bias;
%               number_error=sum(abs(Y_test-sign(Output)))/2;
% 
%               
%       with nonlinear (RBF) kernel:
%               x=[randn(1,50)-1 randn(1,50)+1;randn(1,100)]';
%               y=[-ones(1,50) ones(1,50)]';
%               global rho
%               [nsv,alpha,bias,rho]=irwls_nusvc(x,y,'rbf',.51,4);
%               svcplot(x,y,'rbf',alpha,bias,4);
% 
%               X_test=[randn(1,500)-1 randn(1,500)+1;randn(1,1000)]';
%               Y_test=[-ones(1,500) ones(1,500)]';
%               Output=kernel('rbf',X_test,x(find(alpha),:),4)*(alpha(find(alpha)).*y(find(alpha)))+bias;
%               number_error=sum(abs(Y_test-sign(Output)))/2;
%
% Author:   Fernando Perez-Cruz (fernandop@ieee.org)
% Version:  2.0
% Date:     20th January 2004.
%
%

T=clock;
if (nargin<4 | nargin>5)
    help irwls_nusvc
else
    if(nargin==4 & ker(1)=='p')
        disp('The used kernel needs an input parameter. We have set it to 2.');
        par=2;
    elseif(nargin==4 & ker(1)=='r')
        fprintf(1,'The used kernel needs an input parameter. We have set it to %1.3f\n',sqrt(size(x,2)));
        par=sqrt(size(x,2));
    elseif(nargin==4)
        par=0;
    end
    K=10^4;
    N=size(x,1);
    k=2;
    hacer=1;
    bias=0;
   
    H=kernel(ker,x,x,par).*(y*y');
   
    i1=[1:N]';   
   
    a=zeros(N,1);
    a(i1)=1;
   
    alpha=zeros(N,1);
    bias=0;
    rho=1;
    
    I2=[];
    
    Lp=zeros(1,10000);   
    Lp(1)=N*(1-nu);
    e=ones(N,1);
    while(hacer)      
        alpha_a=alpha;
        bias_a=bias;
        rho_a=rho;
        alpha(i1)=zeros(size(i1));
        alpha(find(e<0))=0;
        alpha(I2)=1;
        if(length(i1))
            Xi=inv([H(i1,i1)+diag(1./(a(i1))) y(i1) -ones(length(i1),1);y(i1)' 0 0;ones(1,length(i1)) 0 0]);
            if(length(I2))
                au=[H(i1,I2)*alpha(I2);y(I2)'*alpha(I2);length(I2)];
            else
                au=[zeros(size(i1));0;0];
            end
            aux=Xi*([zeros(size(i1));0;N*nu]-au);
            alpha(i1)=aux(1:length(i1));
            bias=aux(length(i1)+1);
            rho=aux(length(i1)+2);
        end
      
        e_a=e;        
      
        I=find(alpha-alpha_a);      
        if(length(I))
            e=e_a+(rho-rho_a)-H(:,I)*(alpha(I)-alpha_a(I))-y*(bias-bias_a);
        end
        Lp(k)=alpha'*H*alpha/2-N*nu*rho+sum(e(find(e>0)));
        
        
        if(min(sign(e_a)-sign(e))<-1 | length(find(alpha==1 & e<0)))
            inde1=find(sign(e_a)-sign(e)<0);
            eta1=min(e_a(inde1)./(e_a(inde1)-e(inde1)))+10^-14;
            inde2=find(alpha==1 & e<0);
            eta2=min(e_a(inde2)./(e_a(inde2)-e(inde2)))+10^-14-1/K;      
            eta=[eta1,eta2];
            eta=min(eta);
            alpha_b=eta*alpha+(1-eta)*alpha_a;
            bias_b=eta*bias+(1-eta)*bias_a;
            rho_b=eta*rho+(1-eta)*rho_a;
            e_b=rho_b-H*alpha_b-y*bias_b;
            Lp_b=alpha_b'*H*alpha_b/2-N*nu*rho_b+sum(e_b(find(e_b>0)));
            if(Lp(k)>Lp_b)      
                alpha=alpha_b;
                e=e_b;
                bias=bias_b;
                rho=rho_b;
                Lp(k)=Lp_b;
            end          
        end
        
        
        if(rem(k,10000)==0)
            k
            hacer=0;
            nsv=-1;
            Lp=Lp(k);
        end
        
        
        if(min(a(i1))==K)
            nsv=length(i1)+length(I2);
            hacer=0;
            Lp=Lp(k);
        else
            i1=find(e>0);          
            a=zeros(N,1);
            if(length(i1))
                a(i1)=1./e(i1);
            end
            a(find(a>K))=K;            
            a(find(e==0))=K;
            i1=find(e>=0);
        
            I2=find(alpha>1-10^-3 & alpha<1+10^-3 & e>1/K);
            i1=setdiff(i1,I2);
            
            k=k+1;                        
        end   
    end
end
T=etime(clock,T);