function [x,y,z]=svcplot(X,Y,ker,alpha,bias,par,M)
%This is a routine to plot 2D classification problem with SVM
%
%  [x,y,z]=svcplot(X,Y,ker,alpha,bias,par)
%
%  Parameters: 
%
%              X: matrix of input vectors. Each row of x1 represents a d-dimensional vector. 
%                The number of rows is the number of training samples.
%              Y: column vector of lables (-1 or +1). Each row represent the lable of the sample in X.
%              ker: the kernel to be employed. It has to be a string out of: 'linear', 'poly_h', 'poly_i' and 'rbf'.
%                Type help kernel for further information.
%              alpha: Lagrange Multipliers, multiplied by the lables (the second output of irwls.m)
%              bias: Bias term.  (the third output of irwls.m)
%              par: is the parameter of the used kernel. type help kernel for further information.
%                   (The same value used for the 5th input parater in irwls.m).
%
%  Author: Steve Gunn (srg@ecs.soton.ac.uk)
%  Modified by: Fernando Perez-cruz (fernandop@tsc.uc3m.es
global rho
if(length(rho)==0)
    rho=1;
end
  if (nargin < 5 | nargin > 7) % check correct number of arguments
    help svcplot
  else      
   if(nargin==5 & ker(1)~='l')
       disp('The used kernel needs an input parameter.');
       return
   elseif(nargin==5)
       par=0;
   end
   if(nargin<=6)% Scale the axes
        xmin = min(X(:,1));, xmax = max(X(:,1)); 
        ymin = min(X(:,2));, ymax = max(X(:,2));
    end
    if(nargin==7 & M==1)        
        xmin=0;
        xmax=1;
        ymin=0;
        ymax=1;
    else
        xmin = min(X(:,1));, xmax = max(X(:,1)); 
        ymin = min(X(:,2));, ymax = max(X(:,2));
    end

    epsilon = 1e-10;  
    
    xa = (xmax - xmin);, ya = (ymax - ymin);
    
    if (0.75*abs(xa) < abs(ya)) 
       offadd = 0.5*(ya*4/3 - xa);, 
       xmin = xmin - offadd - 0.05*ya;, xmax = xmax + offadd + 0.05*ya;
       ymin = ymin - 0.05*ya;, ymax = ymax + 0.05*ya;
    else
       offadd = 0.5*(xa*3/4 - ya);, 
       xmin = xmin - 0.05*xa;, xmax = xmax + 0.05*xa;
       ymin = ymin - offadd - 0.05*xa;, ymax = ymax + offadd + 0.05*xa;
    end
    
    set(gca,'XLim',[xmin xmax],'YLim',[ymin ymax]);  

    % Plot function value

    [x,y] = meshgrid(xmin:(xmax-xmin)/50:xmax,ymin:(ymax-ymin)/50:ymax);
    z = bias*ones(size(x));
    Ind=find(alpha);
    for x1 = 1 : size(x,1)
      for y1 = 1 : size(x,2)
		  z(x1,y1)=kernel(ker,[x(x1,y1) y(x1,y1)],X(Ind,:),par)*(alpha(Ind).*Y(Ind))+bias;
     end
  end
    l = (-min(min(z)) + max(max(z)))/2.0;
    sp = pcolor(x,y,z);
    shading interp  
    set(sp,'LineStyle','none');
    set(gca,'Clim',[-l  l],'Position',[0 0 1 1])
    axis off
    load cmap
    colormap(colmap)

    % Plot Training points

    hold on
    for i = 1:size(Y)
      if (Y(i) == 1)
        plot(X(i,1),X(i,2),'b+','LineWidth',4) % Class A
      else
        plot(X(i,1),X(i,2),'r+','LineWidth',4) % Class B
      end
    end 
   
    for i = 1:size(Y)
      if (abs(alpha(i)) > epsilon)
        if (Y(i) == 1)
          plot(X(i,1),X(i,2),'b+','LineWidth',4) % Class A
        else
          plot(X(i,1),X(i,2),'r+','LineWidth',4) % Class B
        end
        plot(X(i,1),X(i,2),'wo') % Support Vector
      end
   end 
   axis equal

    % Plot Boundary contour

    hold on
    contour(x,y,z,[0 0],'w')
    contour(x,y,z,[-rho -rho],'w:')
    contour(x,y,z,[rho rho],'w:')
    hold off

  end    
