function svm(n,C_nu,ker,tipo,par)
%
%Demo to solve 2 Dimensional SVMs.
%
% n number of samples per class.
%
% C_nu: the paramter of the SVM either C if we are solving tipo=1 and nu if
% we are solving tipo=2.
%
% ker is a string containing the selected kernel:
%   'linear'  - Linear kernel
%   'poly_h'  - Homegenious polynomial kernel. par is degree of polynomial. 
%   'poly_i'  - Inhomogenious polynomial kernel. par is degree of polynomial.
%   'rbf'     - RBF kernel. par is width of rbfs (sigma).
%
% tipo: if we solve the problem uning C-SVM (tipo=1) or nu-SVM (tipo=2).
%
% par: if the hyperparameter of the kernel. Either sigma for the RBF or the
% degree of the polynomial.
%
%The functions used to contruct and plot the SVM solution has their own
%help.


close all
if(ker(1)=='l')
    par=0;
end
x=zeros(2*n,2);
y=[ones(n,1);-ones(n,1)];
figure
axis([0 1 0 1])
for i=1:n
    x(i,:)=ginput(1);
    plot(x(1:i,1),x(1:i,2),'b+','LineWidth',4);
    axis([0 1 0 1])
end

for i=n+1:2*n
    x(i,:)=ginput(1);
    plot(x(1:n,1),x(1:n,2),'b+',x(n+1:i,1),x(n+1:i,2),'r+','LineWidth',4);
    axis([0 1 0 1])
end
disp('press a enter to continue')
pause
if(tipo==1)
    [nsv,alpha,bias]=irwls_svc(x,y,ker,C_nu,par);
    svcplot(x,y,ker,alpha,bias,par,1);
elseif(tipo==2)
    [nsv,alpha,bias,rho]=irwls_nusvc(x,y,ker,C_nu,par);
    svcplot(x,y,ker,alpha,bias,par,1);
end