




/*
 *  Copyright 2003 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */

#include "filtercfg.h"

/*
 *  The Board Support Library is divided into several modules, each
 *  of which has its own include file.  The file dsk6713.h must be included
 *  in every program that uses the BSL.  This example also includes
 *  dsk6713_led.h and dsk6713_dip.h because it uses the LED and DIP modules.
 */
#include "dsk6713.h"
#include "dsk6713_led.h"
#include "dsk6713_dip.h"
#include "dsk6713_aic23.h"
#include <csl_irq.h>

/*
 *  main() - Main code routine, initializes BSL and runs LED application
 */

/*
 *  EXTRA: Pressing DIP switch #3 changes LED #3 from off to on.
 */

int active_led=0;
/*
 * Configuracion del AC23
 *
 */

DSK6713_AIC23_Config config = {
    0x0017, // 0 DSK6713_AIC23_LEFTINVOL  Left line input channel volume
    0x0017, // 1 DSK6713_AIC23_RIGHTINVOL Right line input channel volume
    0x00d8, // 2 DSK6713_AIC23_LEFTHPVOL  Left channel headphone volume
    0x00d8, // 3 DSK6713_AIC23_RIGHTHPVOL Right channel headphone volume
    0x0011, // 4 DSK6713_AIC23_ANAPATH    Analog audio path control
    0x0000, // 5 DSK6713_AIC23_DIGPATH    Digital audio path control
    0x0000, // 6 DSK6713_AIC23_POWERDOWN  Power down control
    0x0043, // 7 DSK6713_AIC23_DIGIF      Digital audio interface format
    0x0001, // 8 DSK6713_AIC23_SAMPLERATE Sample rate control
    0x0001  // 9 DSK6713_AIC23_DIGACT     Digital interface activation
};

DSK6713_AIC23_CodecHandle hCodec;

Int16 buffer0[]  ={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
Int16 buffer1[]  ={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
Int16 coefs_ch0[]={ 0,
				   -121,
				   -372,   
				   -535,    
				   0,
				   1753,
				   4493,
				   7087,
				   8157,    
				   7087,    
				   4493,    
				   1752,    
				   0,   
				   -535,
				   -372,
				   -121,
				   0};
Int16 coefs_ch1[]={ 0,    
					172,
					0,
					-761,
					0,
					2494,
					0,
				    -10083,
				    16413,
				    -10083,
				    0,
				    2494,
				    0,
				    -761,
					0,
					172,
					0};
int buffer_len = 17;
int buffer0_pos=0;
int buffer1_pos=0;
int flag=0;

void init_hwi();
void rotate_leds();
void initIrq();

void main()
{


    /* Initialize the board support library, must be first BSL call */
    DSK6713_init();

    /* Initialize the LED and DIP switch modules of the BSL */
    DSK6713_LED_init();
    DSK6713_DIP_init();
    
	active_led=0;
	buffer0_pos=0;
	buffer1_pos=0;
    IRQ_globalDisable();       // Disable global interrupts during setup

	//CODEC  Initialization
    hCodec = DSK6713_AIC23_openCodec(0, &config);
	DSK6713_AIC23_setFreq(hCodec,DSK6713_AIC23_FREQ_8KHZ);
	initIrq();
	IRQ_globalEnable();       // Disable global interrupts during setup

}

void rotate_leds()
{
	int next_led=active_led;
	next_led=(active_led+1) % 4;
	DSK6713_LED_on(next_led);
	DSK6713_LED_off(active_led);
	active_led=next_led;
}

void initIrq()
{
    /* Enable RXTX interrupts to the CPU */
    IRQ_clear(IRQ_EVT_RINT1);   // Clear any pending RX interrupts
    IRQ_enable(IRQ_EVT_RINT1);   // Enable RX interrupt
}

void procRXInt(void)
{
  Uint32 Channel=0;
  Int32 Output=0;
  Int32 Acumulador =0;
  int c;
  DSK6713_AIC23_read(hCodec,&Channel);
  Acumulador = 0;
  if ( ! flag ){
    buffer0[0]=Channel;
    for (c=buffer_len-1 ; c>0 ; c--){
      Acumulador += buffer0[c]*coefs_ch0[c];
      buffer0[c] = buffer0[c-1];
    }
    Acumulador += buffer0[0]*coefs_ch0[c];
  } else {
    buffer1[0]=Channel;
    for (c=buffer_len-1; c>0 ; c--){
      Acumulador += buffer1[c]*coefs_ch1[c];
      buffer1[c] = buffer1[c-1];
    }
    Acumulador += buffer1[0]*coefs_ch1[c];
  }
  Output = Acumulador>>15;
  flag = !flag;  
  DSK6713_AIC23_write(hCodec,Output);
}
