#!/bin/bash
#
# Script that executes test over MCS
# 4 March 2010
#
# Ivn Gonzlez Daz
# igonzalez@tsc.uc3m.es
#
# -------------------------------------------------------------------------------------
# Description: 
# It executes some tests varying the values of the parameters
# -------------------------------------------------------------------------------------



#Folder with video files 
FileDir="d:\videos"
#Output Folder to store results
resDir="./results"
mkdir $resDir

# --------------------------------
# list of Files
FileList="football coastguard mobile paris container tempete"



# --------------------------------
#QP List
QPList="5 10 15 20 25 30 35 40 45 50"

# --------------------------------
#Coding structure
# IP  IntraPeriod=0 FrameSkip=0 NumberBFrames=0# --------------------------------
# I   IntraPeriod=1 FrameSkip=0 NumberBFrames=0
# I1B IntraPeriod=0 FrameSkip=1 NumberBFrames=1
# I2B IntraPeriod=0 FrameSkip=2 NumberBFrames=2
# I3B IntraPeriod=0 FrameSkip=3 NumberBFrames=3
CodingTypeList="IP I2B"


# --------------------------------
# Specifies the modeTypes included in the experiments
# Group1: only 16x16
# Group2: only 16x16 y 8x8
# Group3: only 16x16, 8x8 y 4x4
# Group4: only 16x16, 16x8, 8x16, 8x8
# Group5: all modes
ModeTypeList="Group5"




# --------------------------------
#	CODING
# --------------------------------
for strFile in $FileList; do
for QP in $QPList; do
for codingType in $CodingTypeList; do
for modeType in $ModeTypeList; do

	strFilePath=$FileDir"/"$strFile".cif"
	strParam1=" -p InputFile="$strFilePath
	strParam2=" -p QPISlice="$QP" -p QPPSlice="$QP" -p QPBSlice="$QP     

	if [ "$codingType" = "I" ]; then
		strParam3=" -p IntraPeriod=1 -p FrameSkip=0 -p	NumberBFrames=0 -p FramesToBeEncoded=30"
	else if [ "$codingType" = "IP" ]; then
		strParam3=" -p IntraPeriod=25 -p FrameSkip=0 -p	NumberBFrames=0 -p FramesToBeEncoded=100"
	else if [ "$codingType" = "I1B" ]; then
		strParam3=" -p IntraPeriod=12 -p FrameSkip=1 -p	NumberBFrames=1 -p FramesToBeEncoded=50"
	else if [ "$codingType" = "I2B" ]; then
		strParam3=" -p IntraPeriod=10 -p FrameSkip=2 -p	NumberBFrames=2 -p FramesToBeEncoded=33"
	else if [ "$codingType" = "I3B" ]; then
		strParam3=" -p IntraPeriod=8 -p FrameSkip=3 -p	NumberBFrames=3 -p FramesToBeEncoded=25"
	else
		echo "CodingType not known"
		break
	fi
	fi
	fi
	fi
	fi

	if [ "$modeType" = "Group1" ]; then
		strParam4=" -p InterSearch16x16=1"
	else if [ "$modeType" = "Group2" ]; then
		strParam4=" -p InterSearch16x16=1 -p InterSearch8x8=1"
	else if [ "$modeType" = "Group3" ]; then
		strParam4=" -p InterSearch16x16=1 -p InterSearch16x8=1 -p InterSearch8x16=1"
	else if [ "$modeType" = "Group4" ]; then
		strParam4=" -p InterSearch16x16=1 -p InterSearch16x8=1 -p InterSearch8x16=1 -p InterSearch8x8=1"
	else if [ "$modeType" = "Group5" ]; then
		strParam4=" -p InterSearch16x16=1 -p InterSearch16x8=1 -p InterSearch8x16=1 -p InterSearch8x8=1 -p InterSearch8x4=1 -p InterSearch4x8=1 -p InterSearch4x4=1"
	else
		echo "modeType not known"
		break
	fi
	fi
	fi
	fi
	fi

	strParamGlobal=$strParam1$strParam2$strParam3$strParam4

	strOUTPUT=$strFile"_QP"$QP"_"$codingType
	echo $strOUTPUT

	./lencod.exe -f encoder.cfg $strParamGlobal > "OUTPUT.OUT"
	echo $modeType >> $strFile".out"
	cat data.txt >> $resDir"/"$strFile"_MCS_"$codingType".out" 
			

done
done
done
done
