%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% demo: Demo function that implements an Image Retrieval task using gm.m
%%% To use this function, you need the VLFEAT toolbox (http://www.vlfeat.org/)
function demo()

%IMPORTANT: To change to the path of VLFEAT
run('vlfeat-0.9.18/toolbox/vl_setup');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%Model parameters%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

featMethod='HessianLaplace';    %Type of detector
PeakThreshold=50;               %Peak Threshold for the detector
thRatio=1.4;                    %Ratio Threshold between best and second best matches (As Lowe's paper)
K=2;                            %Number of components in the Generative Model (considering both BG and FG classes)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%Loading Database%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dbFolder='db';
aux=load([dbFolder '/db.mat']);
db=aux.db;
Nrefs=length(db.references);
Nqueries=length(db.queries);
Ncat=length(db.categories);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%Extract Features%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%We compute descriptors for the references
extracFeatDesc([db.folder '/' db.refFolder],db.references,[db.folder '/' db.frefFolder],featMethod,PeakThreshold);
%We compute descriptors for the queries
extracFeatDesc([db.folder '/' db.queryFolder],db.queries,[db.folder '/' db.fqueryFolder],featMethod,PeakThreshold);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%Matching descrtipors and Generative Model%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Matrix with results
sim=zeros(Nqueries,Nrefs);

for q=1:Nqueries
    disp(['Matching query ' db.queries{q}]);
    qPath=[db.folder '/' db.fqueryFolder '/' db.queries{q} '_' featMethod '_' num2str(PeakThreshold) '.mat'];
    fq=load(qPath);
    query_path=[db.folder '/' db.queryFolder '/' db.queries{q} '.jpg'];
    matches=cell(1,Nrefs);
    fr=cell(1,Nrefs);
    ref_paths=cell(1,Nrefs);
    for r=1:Nrefs
        rPath=[db.folder '/' db.frefFolder '/' db.references{r} '_' featMethod '_' num2str(PeakThreshold) '.mat'];
        ref_paths{r}=[db.folder '/' db.refFolder '/' db.references{r} '.jpg'];
        fr{r}=load(rPath);
        %Matching things
        [idx, dists] = vl_ubcmatch(fq.d,fr{r}.d,thRatio);
        matches{r}.idx=idx;
        matches{r}.dists=dists;
    end
    %We run the Generative Model
    sim(q,:)=gm(query_path,ref_paths,fq,fr,matches,K);
end
sim

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%System Evaluation%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%By query
ap=zeros(1,Nqueries);
%Step 1: Generate category-level outputs
for q=1:Nqueries
    %Generating a binary vector of labels
    qlabels=db.mlabels==db.labels(q);
    %Compute AP (Average Precission)
    ap(q) = computeap(sim(q,:), qlabels);
end 
ap
mean(ap)

