% Function that extract feature points and descriptors for a given set of
% images. Parameters are:
    % imgFolder: Folder containing the images
    % imageNames: A cell array containing the names of the images
    % featFolder: Folder where storing the features
    % featMethod: Detection Method
    % PeakThreshold: TH applied to the method
function extracFeatDesc(imgFolder,imageNames,featFolder,featMethod,PeakThreshold)

if(~exist(featFolder,'dir'))
    mkdir(featFolder)
end
    
%Loop of images
for i=1:length(imageNames)
    outFile=[featFolder '/' imageNames{i} '_' featMethod '_' num2str(PeakThreshold) '.mat'];
    if(~exist(outFile,'file'))
        imgPath=[imgFolder '/' imageNames{i} '.jpg'];
        disp(['Extracting descriptors from image ' imageNames{i} ' and keypoint detector ' featMethod]);
        %Open image and convert it to single grayscale
        im=imread(imgPath);
        im=single(rgb2gray(im));
        %Extracting features and descriptors
        [f d] = vl_covdet(im, 'Method',featMethod, 'EstimateAffineShape', true,'EstimateOrientation', true,'Verbose','DoubleImage',false,'PeakThreshold',PeakThreshold);
        %Saving features and descriptors
        save(outFile,'f','d');
    end
end