% Function that matches points betwen two images and computes the
% similarity between them
% Inputs: 
%   fPath: paths to the feature vectors of both images
%   th_ratio: Threshold over the ratio of distances. A descriptor D1 
%   is matched to a descriptor D2 only if the distance d(D1,D2) 
%   multiplied by THRESH is not greater than the distance of D1 
%   to all other descriptors
function sim=featMatching(fPath1,fPath2,th_ratio)
    
    f1=load(fPath1);
    f2=load(fPath2);
    [matches, scores] = vl_ubcmatch(f1.d,f2.d,th_ratio);
    sim=length(scores);
