%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                   Ejercicio 1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear
close all

disp(' ')
disp(' ')
disp('Ejercicio 1:')
disp(' ')
disp('x(t;w_1)=1 forall t>=0')
disp('x(t;w_2)=2 forall t>=0')
disp('x(t;w_3)=exp(-t) forall t>=0')
disp('x(t;w_4)=sin(t) forall t>=0')
disp(' ')
disp('p(w_1)=p(w_2)=p(w_3)=p(w_4)=1/4')
disp(' ')
disp(' ')
disp('Press return to generate a sample from this process')
pause

%%%%%%%%%%%%%%%%%% Def. Proceso %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
t=-2:.01:10;
%Definimos las posibles seales que forman nuestro proceso
x_1 = 1;
x_2 = 2;
x_3 = exp(-t);
x_4 = sin(t);

%Definimos un pulso
pulso = [zeros(1,200) ones(1,1001)];

%%%%%%%%%%%%%%%% Generacin de una realizacin %%%%%%%%%%%%%%%%%%%%%%%%%%

%Generamos una realizacin del proceso
w=ceil(4*rand);
figure(1)
if(w==1)
   H=plot(t,x_1*pulso,'linewidth',2);
elseif(w==2)
   H=plot(t,x_2*pulso,'linewidth',2);
elseif(w==3)
   H=plot(t,x_3.*pulso,'linewidth',2);
elseif(w==4)
   H=plot(t,x_4.*pulso,'linewidth',2);
end
set(get(H(1),'parent'),'fontsize',15);
xlabel('t','fontsize',25)
ylabel('x(t,w_i)','fontsize',25)
hold on

%Generamos varias realizaciones del proceso
Q=['b','g','r','c','m','y','k'];
for i=2:20
   if(i<=5)
       disp('Press return to generate another sample from this process')
       pause
   end
   w=ceil(4*rand);
   if(w==1)
       plot(t,x_1*pulso,Q(mod(i-1,7)+1),'linewidth',2);
   elseif(w==2)
       plot(t,x_2*pulso,Q(mod(i-1,7)+1),'linewidth',2);
   elseif(w==3)
       plot(t,x_3.*pulso,Q(mod(i-1,7)+1),'linewidth',2);
   elseif(w==4)
       plot(t,x_4.*pulso,Q(mod(i-1,7)+1),'linewidth',2);
   end
   drawnow
end
hold off

%%%%%%%%%%%%%%%%%%%%% Media %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
disp(' ')
disp(' ')
disp('Press return to generate the mean of this process')
pause

%Calculamos la media del proceso
media = x_1.*pulso/4 + x_2.*pulso/4 + x_3.*pulso/4 + x_4.*pulso/4;

figure(2)
H=plot(t,x_1*pulso,'--',t,x_2*pulso,'--',t,x_3.*pulso,'--',t,x_4.*pulso,'--');
hold on
plot(t,media,'k','linewidth',2)
hold off
set(get(H(1),'parent'),'fontsize',15);
xlabel('t','fontsize',25)
ylabel('m_X(t)','fontsize',25)

%%%%%%%%%%%%%%%%%%%%% Autocorrelacin %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

disp(' ')
disp(' ')
disp('Press return to generate the autocorrelation of this process')
pause

t=-2:.1:10;

%Definimos un pulso 
pulso = [zeros(1,20) ones(1,101)];

%Calculamos la autocorrelacin del proceso
x1 = x_1*pulso;
x2 = x_2*pulso;
x3 = exp(-t).*pulso;
x4 = sin(t).*pulso;

Rx = zeros(length(t));
for t1 = 1:length(t)
   for t2 = 1:length(t)
       Rx(t1,t2) = (x1(t1)*x1(t2) + x2(t1)*x2(t2) + x3(t1)*x3(t2) + x4(t1)*x4(t2))/4;
   end
end

figure(3)
H=mesh(t,t,Rx);
set(get(H(1),'parent'),'fontsize',15);
xlabel('t_1','fontsize',25)
ylabel('t_2','fontsize',25)
zlabel('R_X(t_1,t_2)','fontsize',25)
axis([-2 10 -2 10 0 1.5])



