function [simbolos_qam,bits_simbolo]=codifica_gray_qam(bits,M);
%
% Funcion que transforma una secuencia de bits en una secuencia de smbolos
% de una constelacin M-PAM siguiendo una codificacin de Gray
%
%  [simbolos_pam,bits_simbolo]=codifica_gray_qam(bits,M);
%
%          bits : secuencia de bits a codificar (1 x Nbits)
%                 Nbits debe ser un multiplo entero de m=log2(M), 
%                 ya que en la asignacion binaria hay m bits por simbolo
%             M : orden (numero de simbolos) de la constelacion M-PAM
%
%  simbolos_pam : simbolos M-QAM codificados (1 x Nsimbolos)
%                 Nsimbolos = Nbits / m
%  bits_simbolo : bits asignados a cada smbolo (m x Nsimbolos)
%
% LABORATORIO DE COMUNICACIONES DIGITALES   
%
%        Version: 1.0
%  Realizado por: Marcelino Lazaro
%                 Departamento de Teoria de la Seal y Comunicaciones
%                 Universidad Carlos III de Madrid
%      Creacion : octubre 2011
% Actualizacion : octubre 2011
%

L = length(bits);
m = log2(M);
M2 = sqrt(M);
m2 = log2(M2);

bits_simbolo = zeros(m,L/m);
bits_simbolo(:)=bits;

bits_simbolo_I = bits_simbolo(1:m2,:);
bits_simbolo_Q = bits_simbolo(m2+1:end,:);

bits_I = transpose(bits_simbolo_I(:));
bits_Q = transpose(bits_simbolo_Q(:));

simbolos_qam_I=codifica_gray_pam(bits_I,M2);
simbolos_qam_Q=codifica_gray_pam(bits_Q,M2);
simbolos_qam = simbolos_qam_I + i*simbolos_qam_Q;


