function [simbolos_pam,bits_simbolo]=codifica_secuencial_pam(bits,M);
%
% Funcion que transforma una secuencia de bits en una secuencia de smbolos
% de una constelacin M-PAM siguiendo una codificacin secuencial
%
%  [simbolos_pam,bits_simbolo]=codifica_secuencial_pam(bits,M);
%
%          bits : secuencia de bits a codificar (1 x Nbits)
%                 Nbits debe ser un multiplo entero de m=log2(M), 
%                 ya que en la asignacion binaria hay m bits por simbolo
%             M : orden (numero de simbolos) de la constelacion M-PAM
%
%  simbolos_pam : simbolos M-PAM codificados (1 x Nsimbolos)
%                 Nsimbolos = Nbits / m
%  bits_simbolo : bits asignados a cada smbolo (m x Nsimbolos)
%
% LABORATORIO DE COMUNICACIONES DIGITALES   
%
%        Version: 1.0
%  Realizado por: Marcelino Lazaro
%                 Departamento de Teoria de la Seal y Comunicaciones
%                 Universidad Carlos III de Madrid
%      Creacion : octubre 2011
% Actualizacion : octubre 2011
%

L=length(bits);
m=log2(M);

bits_simbolo = zeros(m,L/m);
bits_simbolo(:)=bits;
indices_bits = bi2de(transpose(bits_simbolo),'left-msb');

%[indices_pam,mapeo_pam]=bin2gray(indices_bits,'pam',M);
indices_pam = indices_bits;
simbolos_pam = transpose( indices_pam*2 - (M-1) );
