function [bits_dec,bits_simbolo_dec]=decodifica_gray_pam(simbolos_pam,M);
%
% Funcion que realiza la conversion de simbolos de una constelacion M-PAM a
% bits siguiendo una asignacion binaria de Gray
%
%  bits_dec=decodifica_gray_pam(simbolos_pam,M)
%
%    simbolos_pam : vector de simbolos M-PAM a decodificar (1 x Nsimbolos)
%               M : orden (numero de simbolos de la constelacion)
%
%        bits_dec : bits decodificados a partir de los simbolos (1 x Nbits)
%                   Nbits = Nsimbolos x m, siendo m=log2(M) el numero de
%                   bits por simbolo de la constelacion
%
% LABORATORIO DE COMUNICACIONES DIGITALES   
%
%        Version: 1.0
%  Realizado por: Marcelino Lazaro
%                 Departamento de Teoria de la Seal y Comunicaciones
%                 Universidad Carlos III de Madrid
%      Creacion : octubre 2011
% Actualizacion : octubre 2011
%
%

indices_pam=(simbolos_pam+(M-1))/2;
[indices_bits,mapeo] = gray2bin(indices_pam,'pam',M);
bits_simbolo_dec = transpose(de2bi(indices_bits,'left-msb'));
bits_dec = transpose(bits_simbolo_dec(:));