function [observacion_q,bits,simbolos_pam]=genera_observacion_Viterbi_pam(M,canal,L,cabecera,EbN0_dB);
%
% Funcion que genera la secuencia de observaciones, y los correspondientes 
% simbolos transmitidos, y bits transmitidos, cuando se transmite a traves
% de un cierto canal discreto equivalente. Dicha secuencia de observaciones
% podra ser utilizadas para aplicar el algoritmo de Viterbi para
% decodificar una secuencia de la longitud especificada. Se considera una
% modulacion M-PAM
%
%  [observacion_q,bits,simbolos_pam]=genera_observacion_Viterbi_pam(M,canal,L,cabecera,EbN0_dB);
%
%             M : orden (numero de simbolos) de la constelacion M-PAM
%         canal : vector con los coeficientes del canal discreto equivalente, de
%                 tamao 1 x (K+1) 
%             L : longitud de la secuencia a decodificar
%      cabecera : cabecera necesaria para forzar un estado conocido en el
%                 diagrama de rejilla (1 x K)
%       EbN0_dB : Relacion Eb/N0 expresada en decibelios
%
% observacion_q : vector de observaciones resultantes para una cierta
%                 secuencia de tamao L simbolos (1 x (L+K))
%          bits : vector con los bits transmitidos en ese caso (1 x Nbits)
%                 Nbits = L x m, siendo m=log2(M) en numero de bits por
%                 simbolo de la constelacion
%  simbolos_pam : vector con la secuencia de simbolos transmitidos (1 x L)
%
% LABORATORIO DE COMUNICACIONES DIGITALES   
%
%        Version: 1.0
%  Realizado por: Marcelino Lazaro
%                 Departamento de Teoria de la Seal y Comunicaciones
%                 Universidad Carlos III de Madrid
%      Creacion : octubre 2011
% Actualizacion : octubre 2011
%

m=log2(M);
K = length(canal)-1;

Nsimbolos = L;

Nbits =Nsimbolos*m; 

Es = calcula_Es(M,'pam');
Eb = Es/m;

EbN0 = 10^(EbN0_dB/10);
N0 = Eb / EbN0;

bits = genera_bits(Nbits);
simbolos_pam=codifica_gray_pam(bits,M);

simbolos_total = [cabecera, simbolos_pam, cabecera];
observacion_o = conv(simbolos_total,canal);
ruido = genera_ruido(L+K,N0,'BB');
observacion_q = observacion_o(K+(1:L+K)) + ruido;