function s=genera_pam(N,M);
%
% Funcion que genera una secuencia aleatoria de simbolos de una constelacion M-PAM  
%
%  simbolos_pam = genera_pam(Nsimbolos,M)
%
%    Nsimbolos : numero de simbolos a generar
%            M : orden (numero de simbolos) de la constelacion M-PAM
%                (por defecto M=2)
%
% simbolos_pam : vector con la secuencia de simbolos generados (1 x Nsimbolos)
%
% LABORATORIO DE COMUNICACIONES DIGITALES   
%
%        Version: 1.0
%  Realizado por: Marcelino Lazaro
%                 Departamento de Teoria de la Seal y Comunicaciones
%                 Universidad Carlos III de Madrid
%      Creacion : octubre 2011
% Actualizacion : octubre 2011
%
%
%

if nargin < 2
    M=2;
end
m=log2(M);
if (round(m) ~= m)
    error('Tamano incorrecto de la constelacin ...')
end

Alfabeto = -(M-1):2:(M-1);


L=length(Alfabeto);
s=ceil(L*rand(1,N));
auxr=ceil(L*rand(1,N));
s=Alfabeto(auxr);