function s=genera_qam(N,M);
%
% Funcion que genera una secuencia aleatoria de simbolos de una constelacion M-PAM  
%
%  simbolos_qam = genera_qam(Nsimbolos,M)
%
%    Nsimbolos : numero de simbolos a generar
%            M : orden (numero de simbolos) de la constelacion M-QAM
%                (por defecto M=4)
%
% simbolos_qam : vector con la secuencia de simbolos generados (1 x Nsimbolos)
%
% LABORATORIO DE COMUNICACIONES DIGITALES   
%
%        Version: 1.0
%  Realizado por: Marcelino Lazaro
%                 Departamento de Teoria de la Seal y Comunicaciones
%                 Universidad Carlos III de Madrid
%      Creacion : octubre 2011
% Actualizacion : octubre 2011
%

if nargin < 2
    M=4;
end

m = log2(M);
m2 = log2(sqrt(M));

if (round(m2) ~= m2)
    error('Constelacion no permitida ....')
end

M2=2^(m2);
S=-(M2-1):2:(M2-1);

L=length(S);
auxr=ceil(L*rand(1,N));
auxi=ceil(L*rand(1,N));
s=S(auxr)+i*S(auxi);