function ruido = genera_ruido(L,N0,banda);
%
% Funcion que genera una secuencia discreta aleatoria de ruido gausiano 
% y blanco con densidad espectral de potencia N0/2, bien en banda base 
% (seal real) o bien en paso banda (seal compleja)  
%
%  ruido = genera_ruido(Nmuestras,N0,banda)
%
%    Nmuestras : numero de muestras de ruido a generar
%           N0 : valor del parametro N0
%        banda : especifica si es para una modulacion en banda base ('BB')
%                o para una modulacion paso banda ('PB')
%                (por defecto banda='BB')
%
%        ruido : vector con las muestras de ruido generadas (1 x Nsimbolos)
%
% LABORATORIO DE COMUNICACIONES DIGITALES   
%
%        Version: 1.0
%  Realizado por: Marcelino Lazaro
%                 Departamento de Teoria de la Seal y Comunicaciones
%                 Universidad Carlos III de Madrid
%      Creacion : octubre 2011
% Actualizacion : octubre 2011
%

if nargin < 3, banda='BB';end

if strcmp(banda,'BB')
    ruido = sqrt(N0/2)*randn(1,L);
elseif strcmp(banda,'PB')
    ruido_I = sqrt(N0/2)*randn(1,L);
    ruido_Q = sqrt(N0/2)*randn(1,L);
    ruido = ruido_I + i*ruido_Q;
else
    error('Parmetro de banda incorrecto ...')
end