
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

#include <mex.h>
#include "matrix.h"

#ifdef Debug_
#notdefine Debug_
#endif

int  SPC_stop(double *mess_s, int size);
int  GC_stop(double *mess_s);
double SPC_update(double *mess);
void SPC_AWGN_6(double *output_c, double *mess_c);
void GC_AWGN_hamming36(double *output_c, double *mess_c);
double RV_AWGN(double *mess_v, int degree_v);

void GLDPC_Dec_AWGN(double *output, double *parameters, double *received, double *matrix_parity, int mrows_par, int ncols_par);

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    double *p_parameters, *p_received, *p_matrix_parity;
    double *p_output;
    int    mrows_parity, ncols_parity;
    
    p_parameters    = mxGetPr(prhs[0]);
    p_received      = mxGetPr(prhs[1]);
    p_matrix_parity = mxGetPr(prhs[2]);
    mrows_parity    = mxGetM(prhs[2]);
    ncols_parity    = mxGetN(prhs[2]);
    
    plhs[0]         = mxCreateDoubleMatrix(1, 51, mxREAL);
    p_output        = mxGetPr(plhs[0]);
    
    GLDPC_Dec_AWGN(p_output, p_parameters, p_received, p_matrix_parity, mrows_parity, ncols_parity);
}

void GLDPC_Dec_AWGN(double *output, double *parameters, double *received, double *matrix_parity, int mrows_par, int ncols_par)
{   
    const double     NU          = *(parameters);
    const int        MAX_ITER    = *(parameters+1);
    const int        CODE_LENGTH = *(parameters+2);
    const double     SATURATION  = *(parameters+3);      
    const int        DEGREE_V    = mrows_par*ncols_par/CODE_LENGTH;
   
    int     i, j, m, n_temp, n_iter, n_rows, n_rows_temp, n_cols, n_cols_temp, nu_row;
    int     n_position, n_position_temp, flag, n_mess[474], n_err;
    int     flag_array[158], rnd, temp, temp_stop, Err_iter[MAX_ITER];
    double  mess_v_temp[2], mess_c_temp[6], mess_c[6], mess_stop[6];
    double  d_iter_check[158][6], d_iter_check_nxt[158][6], d_iter_temp[158][6]; 
    double  d_iteration[474];
    int     pos_error[50], temp_pos, d_flag, d_change_flag;
    
    for (i=0; i<mrows_par; i++)
    {      
        flag_array[i] = *(parameters+4+i);
    }
                
    for (n_rows=0; n_rows<mrows_par; n_rows++)  
    {
        for (n_cols=0; n_cols<ncols_par; n_cols++)
        {
            d_iter_temp[n_rows][n_cols] = 0;
        }
    }
    
    n_err = 0;
    for (i=0; i<CODE_LENGTH; i++)
    {
        if (*(received+i) > 1)
        {
            n_err = n_err+1;
        }
            
    }
    
    if (n_err == 0)
    {       
        for (i=0; i<51; i++)
        {
            *(output+i) = 0; 
        }
    }
    else
    {
        for (n_rows=0; n_rows<mrows_par; n_rows++)  
        {
            for (n_cols=0; n_cols<ncols_par; n_cols++)
            {
                n_position = *(matrix_parity + n_rows + n_cols*mrows_par);
                d_iter_check[n_rows][n_cols] = *(received + n_position - 1);
            }
        }

        for (i=0; i<50; i++)
        {
            pos_error[i] = 0;
        }
        
                                         
        for (n_iter=0; n_iter<MAX_ITER; n_iter++)
        {
//             mexPrintf("Iter  %d \n", n_iter);   
            for (n_rows=0; n_rows<mrows_par; n_rows++)  
            {
                for (n_cols=0; n_cols<ncols_par; n_cols++)
                {
                    mess_c_temp[n_cols] = d_iter_check[n_rows][n_cols];
                }
                
                if (flag_array[n_rows] == 1)
                {
                    SPC_AWGN_6(mess_c, mess_c_temp);
                }
                else
                {                    
                    GC_AWGN_hamming36(mess_c, mess_c_temp);
                }

                for (i=0; i< ncols_par; i++)
                {
                    d_iter_check[n_rows][i] = mess_c[i];
                    
                  //  mexPrintf("aa  %f ", d_iter_check[n_rows][i]);    
                    
                    if (d_iter_check[n_rows][i] > SATURATION)
                    {
                        d_iter_check[n_rows][i] = SATURATION;
                    }
                    else if (d_iter_check[n_rows][i] < -SATURATION)
                    {
                        d_iter_check[n_rows][i] = -SATURATION;
                    }    
               //     mexPrintf(" %f ", d_iter_check[n_rows][i]);                
                }
              //  mexPrintf("llr \n ");       
            }

            for (n_rows=0; n_rows<mrows_par; n_rows++)  
            {
                for (n_cols=0; n_cols<ncols_par; n_cols++)
                {
                    n_position = *(matrix_parity + n_rows + n_cols*mrows_par);
                    n_temp     = 0;

                    for (n_rows_temp=0; n_rows_temp<mrows_par; n_rows_temp++)  
                    {
                        for (n_cols_temp=0; n_cols_temp<ncols_par; n_cols_temp++)
                        {
                            n_position_temp = *(matrix_parity + n_rows_temp + n_cols_temp*mrows_par);

                            if ((n_position_temp == n_position) && (n_rows_temp != n_rows))
                            {
                                mess_v_temp[n_temp] = d_iter_check[n_rows_temp][n_cols_temp];
                                n_temp = n_temp +1;
                            }
                        }
                    }

                    d_iter_check_nxt[n_rows][n_cols] = (*(received + n_position - 1)) + RV_AWGN(mess_v_temp, DEGREE_V);
                    
                    if (d_iter_check_nxt[n_rows][n_cols] > SATURATION)
                    {
                        d_iter_check_nxt[n_rows][n_cols] = SATURATION;
                    }
                    else if (d_iter_check_nxt[n_rows][n_cols] < -SATURATION)
                    {
                        d_iter_check_nxt[n_rows][n_cols] = -SATURATION;
                    }
                }
            }

//             mexPrintf("Iter_llr %d \n ", n_iter);  
                
            for (i=0; i<CODE_LENGTH; i++)
            {
                d_iteration[i] = *(received + i);
                for (n_rows=0; n_rows<mrows_par; n_rows++)  
                {
                    for (n_cols=0; n_cols<ncols_par; n_cols++)
                    {
                        n_position = *(matrix_parity + n_rows + n_cols*mrows_par);

                        if (n_position == i+1)
                        {
                            d_iteration[i] = d_iteration[i] + d_iter_check[n_rows][n_cols];
                        }

                        if (d_iteration[i] > SATURATION)
                        {
                            d_iteration[i] = SATURATION;
                        }
                        else if (d_iteration[i] < -SATURATION)
                        {
                            d_iteration[i] = -SATURATION;
                        }
                    }
                }
                    
//                 if (d_iteration[i] < 0)
//                 {
//                     mexPrintf("aa  %f %d ", *(d_iteration+i),i);   
//                 }

                if (*(d_iteration+i) >= 0)
                {
                    *(d_iteration+i) = 0;
                }
                else if (*(d_iteration+i) < 0)
                {
                    *(d_iteration+i) = 1;
                }
                
//                 if (d_iteration[i] == 1)
//                 {
//                     mexPrintf("bb  %f \n", *(d_iteration+i));
//                 }
                
            }  

            for (n_rows=0; n_rows<mrows_par; n_rows++)  
            {
                for (n_cols=0; n_cols<ncols_par; n_cols++)
                {
                    d_iter_check[n_rows][n_cols] = d_iter_check_nxt[n_rows][n_cols];
                }
            }
            
            /* stopping rule */
            temp_stop = 0;
            for (n_rows=0; n_rows<mrows_par; n_rows++)
            {
                for (n_cols=0; n_cols<ncols_par; n_cols++)
                {                  
                    n_position        = *(matrix_parity + n_rows + n_cols*mrows_par);
                    mess_stop[n_cols] = *(d_iteration + n_position - 1);
                }
                if (flag_array[n_rows] == 1)
                {
                    temp_stop = SPC_stop(mess_stop, ncols_par);
                    if (temp_stop == 1)
                    {
                        break;
                    }
                }
                else
                {
                    temp_stop = GC_stop(mess_stop);
                    if (temp_stop == 1)
                    {
                        break;
                    }
                }
            }
            
            if (temp_stop == 0)
            {
                n_err = 0;
                break;
            }
            else
            {
                n_err = 0;
                for (i=0; i<CODE_LENGTH; i++)
                {
                    if (*(d_iteration+i) == 1)
                    {
                        n_err = n_err+1;
                    }
                }
            }
             //  mexPrintf("Err1  %d \n", n_err);
//             if (n_err <= 15)
//             {
//     //          mexPrintf("Err  %d \n", n_err);
//                 n_err = 0;
//                 break;
//             }              
            
            if (n_err == 0)
            {
                break;
            } 
            
//            Err_iter[n_iter] = n_err;
//             if (Err_iter[n_iter] > Err_iter[n_iter-1])
//             {
//                 break;
//             }
        }
        
        if (n_err != 0)
        {
            temp_pos = 0;
            for (i=0; i<CODE_LENGTH; i++)
            {
                if (*(d_iteration+i) == 1)
                {
                    pos_error[temp_pos] = i;
                    temp_pos = temp_pos + 1;
                }
            }
        } 
        
//         for(n_iter=0; n_iter<MAX_ITER; n_iter++)
//         {
//             mexPrintf("Err1  %d \n", Err_iter[n_iter]); 
//         }
        
        *output = (double)n_err/CODE_LENGTH; 
        
        for (i=0; i<50; i++)
        {
            *(output+i+1) = pos_error[i]; 
        }
    }
}

double SPC_update(double *mess)
{
    double output;   
    
    output = 2*atanh((tanh(mess[0]/2)) * (tanh(mess[1]/2)) * (tanh(mess[2]/2)) * (tanh(mess[3]/2)) * (tanh(mess[4]/2)) );
    
    return output;
}

void SPC_AWGN_6(double *output_c, double *mess_c)
{
    double temp[5];
    double *output;
    
    temp[0] = *(mess_c+1);
    temp[1] = *(mess_c+2);
    temp[2] = *(mess_c+3);
    temp[3] = *(mess_c+4);
    temp[4] = *(mess_c+5);
    *(output_c) = SPC_update(temp);
        
    temp[0] = *mess_c;
    temp[1] = *(mess_c+2);
    temp[2] = *(mess_c+3);
    temp[3] = *(mess_c+4);
    temp[4] = *(mess_c+5);  
    *(output_c+1) = SPC_update(temp);
    
    temp[0] = *mess_c;
    temp[1] = *(mess_c+1);
    temp[2] = *(mess_c+3);
    temp[3] = *(mess_c+4);
    temp[4] = *(mess_c+5);    
    *(output_c+2) = SPC_update(temp);
    
    temp[0] = *mess_c;
    temp[1] = *(mess_c+1);
    temp[2] = *(mess_c+2);
    temp[3] = *(mess_c+4);
    temp[4] = *(mess_c+5);
    *(output_c+3) = SPC_update(temp);
    
    temp[0] = *mess_c;
    temp[1] = *(mess_c+1);
    temp[2] = *(mess_c+2);
    temp[3] = *(mess_c+3);
    temp[4] = *(mess_c+5);
    *(output_c+4) = SPC_update(temp);
    
    temp[0] = *mess_c;
    temp[1] = *(mess_c+1);
    temp[2] = *(mess_c+2);
    temp[3] = *(mess_c+3);
    temp[4] = *(mess_c+4);
    *(output_c+5) = SPC_update(temp);
}

void  GC_AWGN_hamming36(double *output_c, double *mess_c)
{
    double temp1, temp2;
    double tmax;
    int    i;
    
    tmax = mess_c[0];
    for (i=1; i<6; i++)
    {
        if (mess_c[i] > tmax)
        {
            tmax = mess_c[i];
        }
    }

    temp1 = log(exp(mess_c[1]+mess_c[2]+mess_c[3]+mess_c[4]+mess_c[5]-tmax) + exp(mess_c[1]+mess_c[3]-tmax) + exp(mess_c[2]+mess_c[4]-tmax) + exp(mess_c[5]-tmax));
    temp2 = log(exp(mess_c[1]+mess_c[2]+mess_c[5]-tmax) + exp(mess_c[1]+mess_c[4]-tmax) + exp(mess_c[2]+mess_c[3]-tmax) + exp(mess_c[3]+mess_c[4]+mess_c[5]-tmax));    
    *output_c = temp1-temp2;  
    
    temp1 = log(exp(mess_c[0]+mess_c[2]+mess_c[3]+mess_c[4]+mess_c[5]-tmax) + exp(mess_c[0]+mess_c[3]-tmax) + exp(mess_c[2]+mess_c[5]-tmax) + exp(mess_c[4]-tmax));    
    temp2 = log(exp(mess_c[0]+mess_c[2]+mess_c[4]-tmax) + exp(mess_c[0]+mess_c[5]-tmax) + exp(mess_c[2]+mess_c[3]-tmax) + exp(mess_c[3]+mess_c[4]+mess_c[5]-tmax));
    *(output_c+1) = temp1-temp2;

    temp1 = log(exp(mess_c[0]+mess_c[1]+mess_c[3]+mess_c[4]+mess_c[5]-tmax) + exp(mess_c[0]+mess_c[4]-tmax) + exp(mess_c[1]+mess_c[5]-tmax) + exp(mess_c[3]-tmax));
    temp2 = log(exp(mess_c[0]+mess_c[1]+mess_c[3]-tmax) + exp(mess_c[0]+mess_c[5]-tmax) + exp(mess_c[1]+mess_c[4]-tmax) + exp(mess_c[3]+mess_c[4]+mess_c[5]-tmax));
    *(output_c+2) = temp1-temp2;
    
    temp1 = log(exp(mess_c[0]+mess_c[1]+mess_c[2]+mess_c[4]+mess_c[5]-tmax) + exp(mess_c[0]+mess_c[1]-tmax) + exp(mess_c[4]+mess_c[5]-tmax) + exp(mess_c[2]-tmax)); 
    temp2 = log(exp(mess_c[1]+mess_c[2]+mess_c[5]-tmax) + exp(mess_c[0]+mess_c[2]+mess_c[4]-tmax) + exp(mess_c[1]+mess_c[4]-tmax) + exp(mess_c[0]+mess_c[5]-tmax));  
    *(output_c+3) = temp1-temp2;
    
    temp1 = log(exp(mess_c[0]+mess_c[1]+mess_c[2]+mess_c[3]+mess_c[5]-tmax) + exp(mess_c[0]+mess_c[2]-tmax) + exp(mess_c[3]+mess_c[5]-tmax) + exp(mess_c[1]-tmax));
    temp2 = log(exp(mess_c[1]+mess_c[2]+mess_c[5]-tmax) + exp(mess_c[0]+mess_c[1]+mess_c[3]-tmax) + exp(mess_c[2]+mess_c[3]-tmax) + exp(mess_c[0]+mess_c[5]-tmax));
    *(output_c+4) = temp1-temp2;
    
    temp1 = log(exp(mess_c[0]+mess_c[1]+mess_c[2]+mess_c[3]+mess_c[4]-tmax) + exp(mess_c[1]+mess_c[2]-tmax) + exp(mess_c[3]+mess_c[4]-tmax) + exp(mess_c[0]-tmax));
    temp2 = log(exp(mess_c[0]+mess_c[2]+mess_c[4]-tmax) + exp(mess_c[0]+mess_c[1]+mess_c[3]-tmax) + exp(mess_c[2]+mess_c[3]-tmax) + exp(mess_c[1]+mess_c[4]-tmax)); 
    *(output_c+5) = temp1-temp2;
}

double RV_AWGN(double *mess_v, int degree_v)
{
    double output;
    
    if (degree_v == 2)
    {
        output = mess_v[0];
    }
    else if (degree_v == 3)
    {
        output = mess_v[0] + mess_v[1];
    }
    
    return output;
}

int SPC_stop(double *mess_s, int size)
{
    int output;
    int i, temp;
    
    temp = 0;
    for (i=0; i<size; i++)
    {
        temp = temp + mess_s[i];
    }
    output = temp%2;
    return output;
}

int GC_stop(double *mess_s)
{
    int output;

    if ((mess_s[0]==0)&&(mess_s[1]==0)&&(mess_s[2]==0)&&(mess_s[3]==0)&&(mess_s[4]==0)&&(mess_s[5]==0))
    {
        output = 0;
    }
    else if ((mess_s[0]==0)&&(mess_s[1]==0)&&(mess_s[2]==1)&&(mess_s[3]==0)&&(mess_s[4]==1)&&(mess_s[5]==1))
    {
        output = 0;
    }
    else if ((mess_s[0]==0)&&(mess_s[1]==1)&&(mess_s[2]==0)&&(mess_s[3]==1)&&(mess_s[4]==0)&&(mess_s[5]==1))
    {
        output = 0;
    }
    else if ((mess_s[0]==0)&&(mess_s[1]==1)&&(mess_s[2]==1)&&(mess_s[3]==1)&&(mess_s[4]==1)&&(mess_s[5]==0))
    {
        output = 0;
    }
    else if ((mess_s[0]==1)&&(mess_s[1]==0)&&(mess_s[2]==0)&&(mess_s[3]==1)&&(mess_s[4]==1)&&(mess_s[5]==0))
    {
        output = 0;
    }
    else if ((mess_s[0]==1)&&(mess_s[1]==0)&&(mess_s[2]==1)&&(mess_s[3]==1)&&(mess_s[4]==0)&&(mess_s[5]==1))
    {
        output = 0;
    }
    else if ((mess_s[0]==1)&&(mess_s[1]==1)&&(mess_s[2]==0)&&(mess_s[3]==0)&&(mess_s[4]==1)&&(mess_s[5]==1))
    {
        output = 0;
    }
    else if ((mess_s[0]==1)&&(mess_s[1]==1)&&(mess_s[2]==1)&&(mess_s[3]==0)&&(mess_s[4]==0)&&(mess_s[5]==0))
    {
        output = 0;
    }
    else
    {
        output = 1;
    }         
    return output;
}