% Transmit over AWGN channel QPSK
strH              = (['QC_27_497.mat']);  
load(strH);  

[rows, cols]      = size(Matrix_QC_27);
Degree_v          = 2;  
Degree_c          = 7;
Fraction_v        = 0.75; 
Iter_max          = 10;
Saturation_llr    = 4;   
L_code            = rows * Degree_c / Degree_v + 1; % 497 +1
matrix            = Matrix_QC_27;
 
dB_step           = 1;
dB_min            = 9;
dB_max            = 9;
dB                = dB_min : dB_step : dB_max;
   
Err_SNR_BER_llr   = zeros(1, length(dB));
Err_SNR_BLER_llr  = zeros(1, length(dB));
Err_pos_llr       = zeros(100, 50);

Err_SNR_BER_llr_stop   = zeros(1, length(dB));
Err_SNR_BLER_llr_stop  = zeros(1, length(dB));
Err_pos_llr_stop       = zeros(100, 50);
Baseloop               = 10000000;

% generate the location of generalized constraint nodes
x = randperm(rows);
nu_row = int64(Fraction_v * rows);
x = x(1:nu_row);
Mark_rows = ones(1,rows);
for i = 1 : length(x)
    Mark_rows(1,x(1,i)) = 2;
end


Rho_frac_llr  = [Fraction_v Iter_max L_code Saturation_llr Mark_rows];

for index_db = dB_min : dB_step : dB_max  
    
    Err_ber_llr   = 0;
    Err_bler_llr  = 0;
    
    Err_ber_llr_stop   = 0;
    Err_bler_llr_stop  = 0;
    
    Err_ber_lr   = 0;
    Err_bler_lr  = 0;
    
    err_index = 1;
    
    for index_loop  = 1 : Baseloop
          
        % information
        information      = zeros(1,L_code);
        % modulation codewords before QPSK, all 0 codes
        modulator_qpsk   = ones(1,L_code/2)+1i* ones(1,L_code/2);   
        
        % awgn noise EbNo
        Rm          = 2;
        Rc          = 0.2;  % 1/12;       
        EbNo_linear = 10^(index_db/10); 
        sigma_2     = (2 * Rc * Rm * EbNo_linear)^(-1);
        sigma       = sigma_2/2;
        noise       = sqrt(sigma) * randn(1,L_code/2) + sqrt(sigma) * 1i * randn(1,L_code/2); 
        
        received_n       = modulator_qpsk + noise; 
        received_n_llr   = zeros(1, 2*length(received_n));
        
        for i = 1 : L_code/2
            % the first bit
            if real(received_n(1,i)) >= 1         % this bit is decoded as 0
                received_n_llr(1,2*i-1) = Saturation_llr;
            elseif real(received_n(1,i)) <= -1    % this bit is decoded as 1
                received_n_llr(1,2*i-1) = -Saturation_llr;
            else
                received_n_llr(1,2*i-1) = (2/sigma_2) * real(received_n(1,i));
                
                if (received_n_llr(1,2*i-1) > Saturation_llr)
                    received_n_llr(1,2*i-1) = Saturation_llr;
                elseif (received_n_llr(1,2*i-1) < -Saturation_llr)
                    received_n_llr(1,2*i-1) = -Saturation_llr;
                end
            end
            % the second bit
            if imag(received_n(1,i)) >= 1         % this bit is decoded as 0
                received_n_llr(1,2*i) = Saturation_llr;
            elseif imag(received_n(1,i)) <= -1    % this bit is decoded as 1
                received_n_llr(1,2*i) = -Saturation_llr;
            else
                received_n_llr(1,2*i) = (2/sigma_2) * imag(received_n(1,i));
                 
                if (received_n_llr(1,2*i) > Saturation_llr)
                    received_n_llr(1,2*i) = Saturation_llr;
                elseif (received_n_llr(1,2*i) < -Saturation_llr)
                    received_n_llr(1,2*i) = -Saturation_llr;
                end
            end
        end
    
      % decode
        Err_llr_stop = GLDPC_AWGN_1Matrix_bch_llr_stoppingrule_max_min_27(Rho_frac_llr, received_n_llr(1, 1:L_code-1), matrix);
        
        if (Err_llr_stop(1,1) ~= 0)
        %    fprintf('index_loop %d \n', index_loop);
            Err_bler_llr_stop = Err_bler_llr_stop + 1;
        end   
        Err_ber_llr_stop  = Err_ber_llr_stop + Err_llr_stop(1,1);    
        
        if (Err_llr_stop(1,1) ~= 0)
            Err_pos_llr_stop(err_index,:) = Err_llr_stop(1,2:51);
            err_index = err_index + 1;
        end
 
    end
    i_index_snr = int64((index_db - dB_min) /dB_step +1);
    
    Err_SNR_BER_llr_stop(1, i_index_snr)  = Err_ber_llr_stop/Baseloop;
    Err_SNR_BLER_llr_stop(1, i_index_snr) = Err_bler_llr_stop/Baseloop;
    
end 

x_axis = dB_min+10*log10(Rc)+ 10*log10(Rm): dB_step : dB_max+10*log10(Rc)+ 10*log10(Rm);
save('Infor_llr_stop.mat', 'Err_SNR_BER_llr_stop', 'Err_SNR_BLER_llr_stop');

figure(1)
semilogy(x_axis, Err_SNR_BLER_llr_stop(1, :), 'ro-'); % snr
hold on;
grid on;

