function [ T,R,Reps,Veps,Initial_check ] = BEC_transmission( Bconv, p_mask, epsilon )
%BEC_TRANSMISSION Summary of this function goes here
%   Detailed explanation goes here




d_c=sum(Bconv,1);           %Variable node degree profile in the base matrix
d_r=sum(Bconv,2);           %Check node degree profile in the base matrix.

Num_CN=sum(2.^d_r);         %Num_CN(i) is the total number of possible check node types
                            %that check node i in the base matrix can
                            %generate after transmission over BEC.
[nc,nv]=size(Bconv);


V=ones(1,nv);

T=sparse(Num_CN,nv);
R=zeros(Num_CN,1);
Initial_check=zeros(Num_CN,1);
Reps=zeros(Num_CN,1);

ind_row=1;


%All possible check types and BEC Transmission

Veps=epsilon*V.*p_mask+V.*(1-p_mask);   %After BEC transmission and PD initialization
                                        %Veps is the mean fraction of variable nodes  
                                        %in the base matrix.


for j=1:1:nc                     %(ms+L)*bc: total number of check nodes in the base matrix
    
    %We identify non-zero positions in the j-th row of Bconv
    [~,pos_vector]=find(Bconv(j,:)>0);
    non_zero_vector=Bconv(j,pos_vector);
    mask_sum=[];
    pos_checks=zeros(1,length(non_zero_vector));
    
    %Generation of all check types that the check node in Bconv
    %can generate after PD initialization
    
    CharPatterns=dec2bin(0:1:2^(d_r(j))-1,d_r(j));
    Patterns=zeros(2^d_r(j),d_r(j));
    Patterns(CharPatterns=='1')=1; %Patterns contains all binary vectors with $d_r(j)$ bits
    clear CharPatterns;
    
    
    mask_sum=[mask_sum  1*ones(1,non_zero_vector(1))];
    pos_checks(1)=1;
    for q=2:1:length(non_zero_vector)
        mask_sum=[mask_sum  q*ones(1,non_zero_vector(q))];
        pos_checks(q)=sum(non_zero_vector(1:q-1))+1;
    end;
    
    %mask_sum is a vector of d_r(j) positions that maps what position of
    %each row of Patterns correspond to what variable in Bconv. 
    
    for q=1:1:length(non_zero_vector)
        Patterns(:,pos_checks(q))=sum(Patterns(:,mask_sum==q),2);
        mask_sum(pos_checks(q))=0;
    end;
    Patterns(:,mask_sum>0)=[];
    
    %Patterns now contains all possible check types that the j-th check
    %node in Bconv can generate. non_zero_vector gives the variables
    %connected to the j-th check
    
    %We reduce duplicate rows in Patterns
    [Patterns,~,IC] = unique(Patterns,'rows');
    [~ ,idx] = unique( sort(IC) );
    counts = diff([0;idx]);     %Contains the number of occurences of each pattern
    
    %The T matrix will contain all possible check patterns, where there is
    %a column per variable in Bconv
    T(ind_row:1:ind_row+length(Patterns)-1,pos_vector)=Patterns;
    
    %Initial check will contain the original check node that generated
    %the corresponding check type in T
    Initial_check(ind_row:1:ind_row+length(Patterns)-1)=j;
    %R is a Num_CN table equal to zero except at rows in Patterns
    %corresponding to the original check types in Bconv. It is the initial
    %fraction of each check type.
    R(ind_row+length(Patterns)-1)=1;
    
    
    %%BEC
    %We now compute what is the expected fraction of each check type in the
    %graph after PD initialization. We take into account that some
    %variables can be punctured and thus the variable is erased with
    %probability one.
    
    Patternserased=Patterns.*repmat(p_mask(pos_vector),length(Patterns),1);
    d_r_erased=max(sum(Patternserased,2));
    if(d_r_erased>0)
        Reps(ind_row:1:ind_row+length(Patterns)-1)=counts.*(epsilon.^sum(Patternserased,2).*(1-epsilon).^(d_r_erased-sum(Patternserased,2))).*(sum(Patterns(:,p_mask(pos_vector)==0),2)==sum(non_zero_vector.*(p_mask(pos_vector)==0)));
    else
        Reps(ind_row+length(Patterns)-1)=1;
    end;
    
    ind_row=ind_row+length(Patterns);
    clear Patterns;
    clear Patternserased;
    
    %Reps contains the expacted fraction of each check type in the
    %graph after PD initialization.
    
end;

T=T(1:ind_row-1,:);
R=R(1:ind_row-1);
Reps=Reps(1:ind_row-1);
Initial_check=Initial_check(1:ind_row-1);

end

