%% Peeling decoder evolution for Protograph LDPC codes
%% Both LDPC and SC-LDPC
%% Multiple Connections allowed
%% Puncturing
%% Initializaiton in Matlab, rest in C (Mex file)
%% Degree Distribution components normalized by N (lifting factor)

clear all;
close all;

%% February 2014, Pablo Martinez Olmos olmos@tsc.uc3m.es



epsilon=0.32;
N=20;                                %N^-1 is the step size we use in the numerical evaluation of the solution of the differential equations
Nchains=1;
stopping_factor=1;                %We run the stopping_factor fraction of required iterations (min 0 max 1)
flagVarD1=0;                          %If 1, we compute the variance approximation (slower)

flag_save=1;
save_file=(['noG_B7_' num2str(stopping_factor) ' _N_' num2str(N) '.mat']);

%% Coupled (2,7) %%

B=[ones(1,7); ones(1,7)];
[bc,bv]=size(B);
L=5;
ms=1;

B0=[zeros(1,4) ones(1,3); ones(1,3) zeros(1,4)];
B1=[ones(1,4) zeros(1,3); zeros(1,3) ones(1,4)];

nc=L*bc;
nv=L*bv;

Bconv=zeros(nc,nv);

for i=1:1:L
    Bconv((i-1)*bc+1:(i+1)*bc,(i-1)*bv+1:i*bv)=[B1;B0];
end;

[nc,nv]=size(Bconv);
p_mask=ones(1,nv);   %Puncturing mask: zero for puncturing the corresponding bit in the base matrix




%% %%%%%%%%%%%%%%%%%%%%%%%%%%% PD Transmission  %%%%%%%%%%%%%%%%%%%%%%%%%%%
disp('Transmission...');
[ T,R,Reps,Veps,Initial_check ] = BEC_transmission( Bconv, p_mask, epsilon );


%% %%%%%%%%%%%%%%%%%%%%%%%%%%% PD Preparation  %%%%%%%%%%%%%%%%%%%%%%%%%%%%
format long;

factor=1;                              %Storing factor: save graph DD every factor PD iterations
eps_mean=mean(ones(1,nv).*(1-p_mask)+p_mask*epsilon);
numIt=floor(N*nv*eps_mean/factor*stopping_factor);     %Number of PD iterations allowed
norm_time=N/factor;                    %Normalized time factor
Rmat=zeros(size(R,1),numIt);           %Here we store the check DD after each PD
Vmat=zeros(nv*Nchains,numIt);          %Here we store the node DD after each PD
VarD1mat=zeros(1,numIt);               %Here we store the approximation to the Variance

Rmat(:,1)=Reps;
Vmat(:,1)=Veps;

d_c=sum(Bconv,1);
SD1=[-1*max(d_c):1:max(d_c)-1];      %Vector of all possible changes in the total number c1  of deg1 check nodes


%% %%%%%%%%%%%%%%%%%%%%%%%%%%% PD Analysis  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Step 0: Decodable patterns. Easy in LDPC. We identify what patterns in T
%are decodable. This only has to be computed once.


% ML decoding with Hamming (4,7) codes, SC-LDPC (2,7) structure and Mitchell/Lentmaier labelling

D = sum(T,2)==1;   % BP

% for wrap=1:1:1
%     
%     D=(sum(T,2)==1 | sum(T,2)==2 | sum(T,2)==3);
%     
%     %table_patterns=[4,6,7;1,5,7;1,2,6;2,3,7;2,4,5;3,5,6;1 3 4];
%     
%     [table_patterns,num_pat] = obtain_decodable_erasure_patterns('74.mat',3);
% 
%     
%     %[num_pat,~]=size(table_patterns);
%     
%     [num_rows_T,var_T]=size(T);
%     
%     var_upper_0=find(Bconv(3,:)==1);
%     var_lower_0=find(Bconv(4,:)==1);
%     
%     for j=1:1:L-1
%         
%         %Upper GCN
%         var_upper=var_upper_0+(j-1)*7;
%         
%         for u=1:1:num_pat
%             row_aux=zeros(1,var_T);
%             row_aux(var_upper(table_patterns(u,:)))=1;
%             v_aux=sum(abs(T-repmat(row_aux,num_rows_T,1)),2);
%             
%             D(v_aux==0)=0;
%         end;
%         
%         %Lower GCN
%         var_lower=var_lower_0+(j-1)*7;
%         
%         for u=1:1:num_pat
%             row_aux=zeros(1,var_T);
%             row_aux(var_lower(table_patterns(u,:)))=1;
%             v_aux=sum(abs(T-repmat(row_aux,num_rows_T,1)),2);
%             
%             D(v_aux==0)=0;
%         end;
%         
%     end;
%     
%     j=L;
%     
%     %Upper GCN
%     var_upper=var_upper_0+(j-1)*7;
%     
%     for u=1:1:num_pat
%         
%         if(max(var_upper(table_patterns(u,:)))<=var_T)
%             row_aux=zeros(1,var_T);
%             row_aux(var_upper(table_patterns(u,:)))=1;
%             v_aux=sum(abs(T-repmat(row_aux,num_rows_T,1)),2);
%             
%             D(v_aux==0)=0;
%         end;
%         
%     end;
%     
%     
%     %Lower GCN
%     var_lower=var_lower_0+(j-1)*7;
%     
%     for u=1:1:num_pat
%         
%         if(max(var_lower(table_patterns(u,:)))<=var_T)
%             row_aux=zeros(1,var_T);
%             row_aux(var_lower(table_patterns(u,:)))=1;
%             v_aux=sum(abs(T-repmat(row_aux,num_rows_T,1)),2);
%             
%             D(v_aux==0)=0;
%         end;
%         
%     end;
%     
%     %The deg-3 erasure patterns at left termination are decodable!!
%     
%     
% end;

DDEG=D.*sum(T,2);       %Degree of each decodable pattern

%% MEX FUNCTION
%ind_row=ind_row-1;
%clear b;
%[~,b(1,:)]=unique(Initial_check);
[~,b]=unique(Initial_check);
counts_check=max(diff([0;b]));     %Contains how many check types each original check type generates after BEC transmission



%%%% COMPUTING EXPECTED FINISHING TIME
disp('Test iteration...');
tic;

%[~,~,~,~,~]=PD_LDPC(N,Bconv,bc,bv,L,T+zeros(size(T)),Initial_check',factor,2,norm_time,Rmat(:,1),Vmat(:,1),D+zeros(size(D)),ind_row,ms,max(sum(T>0,1)),sum(T>0,1)',counts_check,Nchains,SD1,max(d_c),flagVarD1);
[~,~,~,~,~]=PD_GLDPC(N,Bconv,nc,nv,L,T+zeros(size(T)),Initial_check,factor,2,norm_time,Rmat(:,1),Vmat(:,1),D+zeros(size(D)),size(R,1),ms,max(sum(T>0,1)),sum(T>0,1)',counts_check,Nchains,SD1,max(d_c),flagVarD1,DDEG+zeros(size(DDEG)));

T0=toc;

fprintf('The simulation is expected to finish in %f minutes.\n You can speed up the simulation (losing accuracy) by setting a smaller N value. \n',T0*numIt/60);

prompt='Do you want to continue (1==y(es) / 0==n(o))?';
answer= input(prompt);

if(answer==1)
    
    tic;
    %%%% START THE ANALYSIS
    [RPD,VPD,it,VARD,MEAND]=PD_GLDPC(N,Bconv,nc,nv,L,T+zeros(size(T)),Initial_check,factor,numIt,norm_time,Rmat(:,1),Vmat(:,1),D+zeros(size(D)),size(R,1),ms,max(sum(T>0,1)),sum(T>0,1)',counts_check,Nchains,SD1,max(d_c),flagVarD1,DDEG+zeros(size(DDEG)));

    %[RPD,VPD,it,VARD,MEAND]=PD_GLDPC(N,Bconv,nc,nv,L,T+zeros(size(T)),Initial_check,factor,100,norm_time,Rmat(:,1),Vmat(:,1),D+zeros(size(D)),size(R,1),ms,max(sum(T>0,1)),sum(T>0,1)',counts_check,Nchains,SD1,max(d_c),flagVarD1,DDEG+zeros(size(DDEG)));
    
    Tfinal=toc;
    
    fprintf('Final Simulation time: %f minutes \n',Tfinal/60);
    
    if(flag_save)
        save(save_file);
    end;
    
    
    
    %% plot results
    
    
    figure(1);
    plot(sum(VPD(:,1:1:it))/(nv/L),sum(RPD(D,1:1:it)/(nv/L),1),'r','LineWidth',2);
    xlabel('$v(\tau)$','Interpreter','Latex','Fontsize',14);
    ylabel('$a(\tau)$','Interpreter','Latex','Fontsize',14);
    
    %     figure(2);
    %     plot((1:1:it)/N/nv,sum(RPD(D,1:1:it)/(nv/L),1),'b','LineWidth',2);
    
    
end;