//******************************DECLARATIONS**************************//

void comp_multiplic_norm(double *a,double *b,int rows,int colA,int colB,int flag_norm,double *output);

void update_Var_types(double *T,int rows, int cols, double *D, double *Probs, double *DeltaVar);

void clean_check_vector(double *checks_mod,double *ProbsCheck,int colP);

void get_deg1_info(int pattern, double *T,int rows, int cols,double *Bconv,
        int rows2, int cols2, double *Initial_check, double *checks_mod,  double *ProbsCheck, int colP,
        int *var, int *degree,double *numcolP,double *RPD, int iteration);


void get_deg1_info_mod(int var_connected,int pattern, double *T,int rows, int cols,double *Bconv,
        int rows2, int cols2, double *Initial_check, int *checks_mod,  double *ProbsCheck, int colP,
        int *var, int *degree, double *numcolP, double *RPD, int iteration);

void update_Check_types(int pattern, double *T,int rows, int cols,double *Bconv,
        int rows2, int cols2, double *Initial_check, int *checks_mod,  double *ProbsCheck, int colP,
        int var, int degree, double *numcolP, double *DeltaCheck, double* ProbsPD, int maxcount,
        double *subT, double *SD1,double *PD1,int posPD1,int maxdeg, int flagVar, int flag_D,int DDEG);

void search_row(double *T,double *newpattern,int rows, int cols);

void search_row(double *T,double *newpattern,int rows, int cols,int *pnew);

void clean_subT(double *subT,int countmax, int cols);

void reset_Delta(double *DeltaVar,int nvar,double *DeltaCheck,int nchecks);

//*******************************FUNCTIONS**************************//
void comp_multiplic_norm(double *a,double *b,int rows,int colA,int colB,int flag_norm,double *output)
{
    //Component wise multiplication and optional normalization
    //a b are matrices with the same number of rows. ColA and ColB
    //denote the columns that are being multiplied. In case of vector they are set
    //to one.
    
    
    double sum=0;
    for (int i=0;i<rows;i++){
        output[i]=a[(colA-1)*rows+i]*b[(colB-1)*rows+i];
        sum=sum+output[i];
    }
    
    if(flag_norm==1){
        for (int i=0;i<rows;i++)
            output[i]=output[i]/sum;
        
    }
    
}

void update_Var_types(double *T,int rows, int cols, double *D, double *Probs, double *DeltaVar)
{
    
    for(int i=0;i<rows;i++){
        if(D[i]==1){
            for (int j=0;j<cols;j++){
                if(T[j*rows+i]>0)
                    DeltaVar[j]=DeltaVar[j]-T[j*rows+i]*Probs[i]; // MODIFIED W.R.T. TO LDPC CASE: If we remove two of them ... -2*Probs[i]
            }
        }
        
        
    }
}

void clean_check_vector(int *checks_mod,double *ProbsCheck,int colP){
    for(int i=0;i<colP;i++){
        checks_mod[i]=-1;
        ProbsCheck[i]=0;
    }
}

void get_deg1_info(int pattern, double *T,int rows, int cols,double *Bconv,
        int rows2, int cols2, double *Initial_check, int *checks_mod,  double *ProbsCheck, int colP,
        int *var, int *degree, double *numcolP, double *RPD, int iteration)
{
    
    //Find the variable connected to the degree one check node
    for (int i=0;i<cols;i++){
        if(T[i*rows+pattern]==1){
            *var=i;
            break;
        }
    }
    
    //Compute the variable degree
    for (int i=0;i<rows2;i++){
        *degree=*degree+Bconv[(*var)*rows2+i];
    }
    
    //Find connected check patterns
    
    int conex=0;
    
    
    
    for (int i=0;i<rows;i++){
        if(T[(*var)*rows+i]>0){
            checks_mod[conex]=i;
            conex++;
            if(conex==numcolP[*var])
                break;
        }
    }
    
    
    
    double sum=0;
    
//         % We compute the probability of each check type to be connected to the
//         % the removed variable (edge perspective!!).
    
//         % The probability is computed as the product of
//         %   1) The number of edges that the variable var has to each check
//         %   type in the base matrix Bconv.
//         %   2) The fraction of checks of each type.
//         %   3) How many times the check type is connected to the variable
//
// (6,10,2014) PROBABILITIES ARE COMPUTED IN DIFFERENT GROUPS!
    
    
    int cpos=checks_mod[0];
    int initial_old=(int) Initial_check[cpos];
    int flag_norm=0;
    int first_index=0;
    double aux=0;
    int deg=*degree;
    
    for (int i=0;i<numcolP[*var];i++)
    {
        
        
        int cpos=checks_mod[i];
        int initial=(int) Initial_check[cpos];
        
        if(initial!=initial_old){
            
            if(sum>0){
                for(int index_back=first_index;index_back<i;index_back++){
                    
                    ProbsCheck[index_back]=ProbsCheck[index_back]/sum*aux;
                }
            }
            first_index=i;
            sum=0;
            initial_old=initial;
        }
        
        
        
        
        int factor=Bconv[(*var)*rows2+initial-1];
        
        
        if(Initial_check[cpos]==Initial_check[pattern])
        {
            factor=factor-1;
        }
        
        aux=factor/(double) (deg-1);
        
        
        
        ProbsCheck[i]=RPD[(iteration-1)*rows+cpos]*T[(*var)*rows+cpos]*factor;
        
        
        sum=sum+ProbsCheck[i];
        
        
        
    }
    
    // We normalize the last set
    if(sum>0){
        for(int index_back=first_index;index_back<numcolP[*var];index_back++){
            ProbsCheck[index_back]=ProbsCheck[index_back]/sum*aux;
        }
        
    }
    
    
}


void get_deg1_info_mod(int var_connected,int pattern, double *T,int rows, int cols,double *Bconv,
        int rows2, int cols2, double *Initial_check, int *checks_mod,  double *ProbsCheck, int colP,
        int *var, int *degree, double *numcolP, double *RPD, int iteration)
{
    int accum_aux=0;
    
    //Find the variable connected to the degree one check node
    for (int i=0;i<cols;i++){
        
        
        accum_aux=accum_aux+T[i*rows+pattern];
        
        if(var_connected<=accum_aux){
            *var=i;
            break;
        }
    }
    
    //Compute the variable degree
    for (int i=0;i<rows2;i++){
        *degree=*degree+Bconv[(*var)*rows2+i];
    }
    
    //Find connected check patterns
    
    int conex=0;
    
    for (int i=0;i<rows;i++){
        if(T[(*var)*rows+i]>0){
            checks_mod[conex]=i;
            conex++;
            if(conex==numcolP[*var])
                break;
        }
    }
    
    
    
    double sum=0;
    
//         % We compute the probability of each check type to be connected to the
//         % the removed variable (edge perspective!!).
    
//         % The probability is computed as the product of
//         %   1) The number of edges that the variable var has to each check
//         %   type in the base matrix Bconv.
//         %   2) The fraction of checks of each type.
//         %   3) How many times the check type is connected to the variable
//
// (6,10,2014) PROBABILITIES ARE COMPUTED IN DIFFERENT GROUPS!
    
    
    int cpos=checks_mod[0];
    int initial_old=(int) Initial_check[cpos];
    int flag_norm=0;
    int first_index=0;
    double aux=0;
    int deg=*degree;
    
    for (int i=0;i<numcolP[*var];i++)
    {
        
        
        int cpos=checks_mod[i];
        int initial=(int) Initial_check[cpos];
        
        if(initial!=initial_old){
            
            if(sum>0){
                for(int index_back=first_index;index_back<i;index_back++){
                    
                    ProbsCheck[index_back]=ProbsCheck[index_back]/sum*aux;
                }
            }
            first_index=i;
            sum=0;
            initial_old=initial;
        }
        
        
        
        
        int factor=Bconv[(*var)*rows2+initial-1];
        
        
        if(Initial_check[cpos]==Initial_check[pattern])
        {
            factor=factor-1;
        }
        
        aux=factor/(double) (deg-1);
        
        
        
        ProbsCheck[i]=RPD[(iteration-1)*rows+cpos]*T[(*var)*rows+cpos]*factor;
        
        
        sum=sum+ProbsCheck[i];
        
        
        
    }
    
    // We normalize the last set
    if(sum>0){
        for(int index_back=first_index;index_back<numcolP[*var];index_back++){
            ProbsCheck[index_back]=ProbsCheck[index_back]/sum*aux;
        }
        
    }
    
    
}

void update_Check_types(int pattern, double *T,int rows, int cols,double *Bconv,
        int rows2, int cols2, double *Initial_check, int *checks_mod,  double *ProbsCheck, int colP,
        int var, int degree, double *numcolP, double *DeltaCheck, double* ProbsPD,
        int maxcount,double *subT,double *SD1,double *PD1,int posPD1,int maxdeg, int flagVar, int flag_D, int DDEG)
{
    
    
    
    //Remove degree-one check node
    //     % We lose one check node of the decodable pattern and gain one
    //     % check node of type degree cero
    
    if(flag_D==0)
        DeltaCheck[pattern]=DeltaCheck[pattern]-ProbsPD[pattern];  //CHECK!! DO WE HAVE TO MULTIPLY BY DDEG?
    
    double newpattern[cols];
    
    for (int i=0;i<cols;i++)
        newpattern[i]=T[i*rows+pattern];
    
    
    newpattern[var]=0;
    
    
//             %For each check pattern affected, we restrict the T matrix to
//             %search the generated pattern after variable removal
    
    int current_check=Initial_check[pattern];
    //We clean the submatrix before
    
    clean_subT(subT,maxcount,cols);
    int counter=0;
    int first=0;
    int flagfirst=0;
    
    //We set subT
    for (int j=0;j<rows;j++)
    {
        if(Initial_check[j]==current_check)
        {
            for (int c=0;c<cols;c++)
                subT[c*maxcount+counter]=T[c*rows+j];
            
            
            if(flagfirst==0)
            {
                first=j;
                flagfirst=1;
            }
            counter++;
        }
        
        if(Initial_check[j]>current_check)
            break;
    }
    
    
    
    int newrow=0;
    int *pnew=&newrow;
    
    
    //  We gain one check node of type degree cero
    search_row(subT,newpattern,maxcount,cols,pnew);
    
    //if(flag_D==0)
    //    DeltaCheck[newrow+first]=DeltaCheck[newrow+first]+ProbsPD[pattern]; //CHECK!! DO WE HAVE TO MULTIPLY BY DDEG?
    
    //  We store the indexes of all new patters to then later compute the PFM of Delta1
    
    int *index_created=(int *) mxCalloc(numcolP[var],sizeof(int));
    
    int *index_pos=(int *) mxCalloc(numcolP[var],sizeof(int));
    
    
    int *dims=(int *) mxCalloc(degree-1,sizeof(int));
    
    
    
    for (int i=0;i<numcolP[var];i++)
    {
        
        int cpos=checks_mod[i];
        
        index_pos[i]=cpos;
        
        if(cpos==-1)
            break;
        
        //We create a submatrix to restric the search of the patterns
        int current_check=Initial_check[cpos];
        //We clean the submatrix before
        
        clean_subT(subT,maxcount,cols);
        int counter=0;
        
        flagfirst=0;
        first=0;
        
        //We set subT
        for (int j=0;j<rows;j++)
        {
            if(Initial_check[j]==current_check)
            {
                for (int c=0;c<cols;c++)
                    subT[c*maxcount+counter]=T[c*rows+j];
                
                
                if(flagfirst==0)
                {
                    first=j;
                    flagfirst=1;
                }
                counter++;
            }
            
            if(Initial_check[j]>current_check)
                break;
        }
        
        // A new check node of a certain pattern is created
        
        
        for (int u=0;u<cols;u++)
            newpattern[u]=T[u*rows+cpos];
        
        newpattern[var]=newpattern[var]-1;
        
        
        search_row(subT,newpattern,maxcount,cols,pnew);
        
        
        DeltaCheck[newrow+first]=DeltaCheck[newrow+first]+(degree-1)*ProbsPD[pattern]*ProbsCheck[i];
        
        index_created[i]=newrow+first;
        
        // A check node of a certain pattern is removed
        
        DeltaCheck[cpos]=DeltaCheck[cpos]-(degree-1)*ProbsPD[pattern]*ProbsCheck[i];
        
        
    }
    
    
    // PMF FOR THE EXPECTED CHANGE IN DEG1 CHECK NODES
    
    int flag=0;
    int flag2=0;
    int maxnum=(int) numcolP[var];  //printf("var:%d\n",var);
    int lost1=0;
    int gain1=0;
    double prob_aux=1;
    int acum_lost=0;
    int acum_gain=0;
    
    
    for (int i=0;i<degree-1;i++)
        dims[i]=0;
    
    
    if(flagVar==1 && degree>1)
    {
        //printf("starting loop until %d^%d\n",maxnum,degree-1);
        
        while(flag<pow(maxnum,degree-1))
        {
            
            
            
            
            for (int i=0;i<degree-1;i++){
                
                acum_lost=0;
                acum_gain=0;
                
                for (int j=0;j<cols;j++){
                    acum_lost+=(int) T[j*rows+checks_mod[dims[i]]];
                    acum_gain+=(int) T[j*rows+index_created[dims[i]]];
                }
                
                if(acum_lost==1)
                    lost1++;
                if(acum_gain==+1)
                    gain1++;
                
                prob_aux=prob_aux*ProbsCheck[dims[i]];
                
                
            }
            
            //printf(" lost1=%d, gain1=%d, Delta1=%d\n",lost1,gain1,gain1-lost1-1);
            
            PD1[gain1-lost1-1+maxdeg]=PD1[gain1-lost1-1+maxdeg]+prob_aux*ProbsPD[pattern];
            
            //printf("Delta1=%d,prob=%f,PD1new=%f\n",gain1-lost1-1,prob_aux*ProbsPD[pattern],PD1[gain1-lost1-1+maxdeg]);
            
            prob_aux=1;
            lost1=0;
            gain1=0;
            flag++;
            flag2=0;
            int d=0;
            while(flag2==0){
                dims[d]=dims[d]+1;
                if(dims[d]>maxnum-1){
                    dims[d]=0;
                    d++;
                }
                else
                    flag2=1;
            }
            //%printf("flag: %d\n",flag);
            
        }
        
    }
    mxFree(index_pos);
    mxFree(index_created);
    mxFree(dims);
}

void search_row(double *T,double *newpattern,int rows, int cols,int *pnew)
{
    int flag=0;
    
    for (int i=0;i<rows;i++)
    {
        flag=1;
        for(int j=0;j<cols;j++)
        {
            if(T[j*rows+i]!=newpattern[j])
            {
                flag=0;
                break;
            }
        }
        if(flag==1)
        {
            flag=i;
            break;
        }
    }
    
    *pnew=flag;
}

void clean_subT(double *subT,int countmax, int cols){
    for(int i=0;i<countmax*cols;i++){
        subT[i]=-1;
    }
}

void reset_Delta(double *DeltaVar,int nvar,double *DeltaCheck,int nchecks){
    
    for(int i=0;i<nvar;i++)
        DeltaVar[i]=0;
    
    for(int i=0;i<nchecks;i++)
        DeltaCheck[i]=0;
}