#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#include "time.h"


#include <iostream>
#include "mex.h"


#include "PC_LDPC.h"

//*******************INPUTS*************//

#define iN prhs[0]
#define iBconv prhs[1]
#define inc prhs[2]
#define inv prhs[3]
#define iL prhs[4]
#define iT prhs[5]
#define iInitial_check prhs[6]
#define ifactor prhs[7]
#define iNumIt prhs[8]
#define inorm_time prhs[9]
#define iRmat prhs[10]
#define iVmat prhs[11]
#define iD prhs[12]
#define iNumPatterns prhs[13]
#define ims prhs[14]
#define icolP prhs[15]
#define inumcolP prhs[16]
#define imaxcount prhs[17]
#define iNchains prhs[18]
#define iSD1 prhs[19]
#define imaxdeg prhs[20]
#define iflagVar prhs[21]
#define iDDEG prhs[22]

//*******************OUTPUTS*************//

#define oRPD plhs[0]
#define oVPD plhs[1]
#define oit  plhs[2]
#define oVAR plhs[3]
#define oMEAN plhs[4]


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[] ) {
    
    //********************CHECK INPUTS AND OUTPUTS************//
    
    if(nrhs < 22)
        mexErrMsgTxt("Invalid number of input arguments\n");
    if(nlhs >5)
        mexErrMsgTxt("Invalid number of ouput arguments");
    
    
    //*************INPUT SCALAR PARAMETERS******************//
    
    int N=0;
    N=mxGetScalar(iN);
    
    int nc=0;
    nc=mxGetScalar(inc);
    
    int nv=0;
    nv=mxGetScalar(inv);
    
    int L=0;
    L=mxGetScalar(iL);
    
    int factor=0;
    factor=mxGetScalar(ifactor);
    
    int NumIt=0;
    NumIt=mxGetScalar(iNumIt);
    
    double norm_time=0;
    norm_time=mxGetScalar(inorm_time);
    
    int NumPatterns=0;
    NumPatterns =mxGetScalar(iNumPatterns);
    
    int ms=0;
    ms=mxGetScalar(ims);
    
    int colP=0;
    colP=mxGetScalar(icolP);
    
    int maxcount=0;
    maxcount=mxGetScalar(imaxcount);
    
    int Nchains=0;
    Nchains=mxGetScalar(iNchains);
    
    int maxdeg=0;
    maxdeg=mxGetScalar(imaxdeg);
    
    int flagVar=0;
    flagVar=mxGetScalar(iflagVar);
    
    
    
    //*************INPUT VECTOR AND MATRICES******************//
    
    double *Bconv;
    Bconv= mxGetPr(iBconv);
    
    double *T;
    T= mxGetPr(iT);
    
    double *Initial_check;
    Initial_check= mxGetPr(iInitial_check);
    
    double *Rmat;
    Rmat=mxGetPr(iRmat);
    
    double *Vmat;
    Vmat=mxGetPr(iVmat);
    
    double *D;
    D= mxGetPr(iD);
    
    double *DDEG;
    DDEG=mxGetPr(iDDEG);
    
    double *numcolP;
    numcolP= mxGetPr(inumcolP);
    
    double *SD1;
    SD1=mxGetPr(iSD1);
    
    
    
    
    //****************Check Dimensions*****************//
    
    const mwSize* pdimBconv=mxGetDimensions(iBconv);
    const mwSize* pdimT=mxGetDimensions(iT);
    const mwSize* pdimInitial=mxGetDimensions(iInitial_check);
    const mwSize* pdimRmat=mxGetDimensions(iRmat);
    const mwSize* pdimVmat=mxGetDimensions(iVmat);
    const mwSize* pdimD=mxGetDimensions(iD);
    const mwSize* pdimDDEG=mxGetDimensions(iDDEG);
    const mwSize* pdimnumcolP=mxGetDimensions(inumcolP);
    
    //if(!(pdimBconv[0]==bc*(L+ms)*Nchains && pdimBconv[1]==L*bv*Nchains))
    if(!(pdimBconv[0]==nc*Nchains && pdimBconv[1]==nv*Nchains))
        mexErrMsgTxt("Invalid size: Bconv\n");
    
    if(!(pdimT[0]==NumPatterns && pdimT[1]==nv*Nchains))
        mexErrMsgTxt("Invalid size: T\n");
    
    if(!(pdimInitial[0]==NumPatterns))
        mexErrMsgTxt("Invalid size: Initial_checks\n");
    
    if(!(pdimRmat[0]==NumPatterns))
        mexErrMsgTxt("Invalid size: Rmat\n");
    
    if(!(pdimVmat[0]==nv*Nchains))
        mexErrMsgTxt("Invalid size: Vmat\n");
    
    if(!(pdimD[0]==NumPatterns))
        mexErrMsgTxt("Invalid size: D\n");
    
    if(!(pdimDDEG[0]==NumPatterns))
        mexErrMsgTxt("Invalid size: DDEG\n");
    
    if(!(pdimnumcolP[0]==nv*Nchains))
        mexErrMsgTxt("Invalid size: Column Patter\n");
    
    //************We allocate memory *************//
    
    oRPD= mxCreateDoubleMatrix(NumPatterns, NumIt, mxREAL);
    double *RPD=mxGetPr(oRPD);
    
    
    oVPD= mxCreateDoubleMatrix(nv*Nchains, NumIt, mxREAL);
    double *VPD=mxGetPr(oVPD);
    
    oit = mxCreateDoubleMatrix(1, 1, mxREAL);
    double *it_counter=mxGetPr(oit);
    
    oVAR =mxCreateDoubleMatrix(1,NumIt,mxREAL);
    double *VAR=mxGetPr(oVAR);
    
    oMEAN =mxCreateDoubleMatrix(1,NumIt,mxREAL);
    double *MEAN=mxGetPr(oMEAN);
    
    mxArray *mxProbsPD= mxCreateDoubleMatrix(NumPatterns, 1, mxREAL);
    double *ProbsPD=mxGetPr(mxProbsPD);
    
    mxArray *mxDeltaCheck= mxCreateDoubleMatrix(NumPatterns, 1, mxREAL);
    double *DeltaCheck=mxGetPr(mxDeltaCheck);
    
    mxArray *mxDeltaVar= mxCreateDoubleMatrix(nv*Nchains, 1, mxREAL);
    double *DeltaVar=mxGetPr(mxDeltaVar);
    
    int *checks_mod=(int *) mxCalloc(colP,sizeof(int));
    
    mxArray *mxProbsCheck= mxCreateDoubleMatrix(colP, 1, mxREAL);
    double *ProbsCheck=mxGetPr(mxProbsCheck);
    
    mxArray *mxsubT= mxCreateDoubleMatrix(maxcount, nv*Nchains, mxREAL);
    double *subT=mxGetPr(mxsubT);
    
    int var=0;
    int *pvar=&var;
    int degree=0;
    int *pdegree=&degree;
    
    
    //We create a vector to store the probabilities of change of c1
    
    const mwSize* pdimSD1=mxGetDimensions(iSD1);
    
    int dimPD1=pdimSD1[1];
    
    
    mxArray *mxPD1= mxCreateDoubleMatrix(dimPD1, 1, mxREAL);
    double *PD1=mxGetPr(mxPD1);
    
    double sumD=0;
    double sumV=0;
    
    //We initialize PD1
    
    for (int i=0;i<dimPD1;i++)
        PD1[i]=0;
    
    //************Function Body*******************//
    
    // We initialize the first iteration to the input values
    
    for (int i=0;i<NumPatterns;i++)
        RPD[i]=Rmat[i];
    
    for (int i=0;i<nv*Nchains;i++)
        VPD[i]=Vmat[i];
    
    VAR[0]=0;
    MEAN[0]=0;
    
    (*it_counter)=(*it_counter)+1;
    
    
    for (int iteration=1;iteration<NumIt;iteration++){
        
        // mexPrintf("Iteration %d\n",iteration+1);
        
        // Step 0: We clean DeltaVar and DeltaCheck vectors
        
        reset_Delta(DeltaVar,nv*Nchains,DeltaCheck,NumPatterns);
        
        for (int i=0;i<pdimSD1[1];i++)
            PD1[i]=0;
        
        //Step 1: Probability of removing a decodable check node.
        
        comp_multiplic_norm(D,RPD,NumPatterns,1,iteration,1,ProbsPD);
        
        
        
        //Step 2: Expected Change in Variable types. It only
        //affects to variables connected to decodable patterns
        
        update_Var_types(T,NumPatterns,nv*Nchains,D,ProbsPD,DeltaVar);
        
        
        double var_evol=0.0;
        
        for (int aux=0;aux<nv*Nchains;aux++){
            
            int vag_deg=0;
            for (int aux2=0;aux2<nc*Nchains;aux2++){
                vag_deg=vag_deg+Bconv[aux*nc*Nchains+aux2];
            }
            
            var_evol=var_evol+DeltaVar[aux]*vag_deg;
        }
        
        
        //Step 3: Expected Change in Degree types
        
        //mexPrintf("var_evol=%f\n",var_evol);
        
        //Step 3: Expected Change in Degree types
        
        //mexPrintf("Pattern %d\n",NumPatterns);
        
        
        for (int pat=0;pat<NumPatterns;pat++)
        {
            
            if(D[pat]==1.0)         // For each decodable pattern
            {
                
                int flag_D=0;
                
                // WE REMOVE AS MANY VARIABLES AS DEGREE OF THE DECODED CHECK
                //mexPrintf("Pat=%d, DDEG=%f\n",pat, DDEG[pat]);
                for (int var_connected=0;var_connected<DDEG[pat];var_connected++)
                {
                    
                    
                    //Cleaning deg1 check information
                    var=0;
                    degree=0;
                    clean_check_vector(checks_mod,ProbsCheck,colP);
                    
                    //Getting information from the check type: connected variable, the variable degree in the original graph,
                    //the check types the variable is connected to and their probability (edge perspective)
                    
                    
                    //get_deg1_info(pat,T,NumPatterns,L*bv*Nchains,Bconv,bc*(L+ms)*Nchains,L*bv*Nchains,Initial_check,checks_mod,ProbsCheck,colP,pvar,pdegree,numcolP,RPD,iteration);
                    get_deg1_info_mod(var_connected+1,pat,T,NumPatterns,nv*Nchains,Bconv,nc*Nchains,nv*Nchains,Initial_check,checks_mod,ProbsCheck,colP,pvar,pdegree,numcolP,RPD,iteration);
                    
                    
                    //Updating Check types
                    
                    //mexPrintf("flag_D=%d,var=%d\n",flag_D,var);
                    
                    update_Check_types(pat,T,NumPatterns,nv*Nchains,Bconv,nc*Nchains,nv*Nchains,Initial_check,checks_mod,
                            ProbsCheck,colP,var,degree,numcolP,DeltaCheck,ProbsPD,maxcount,subT,SD1,PD1,dimPD1,maxdeg,flagVar,flag_D,DDEG[pat]);
                    
                    flag_D=flag_D+1;
      
                    
                }
                
            }

            
        }
        
        
        double check_evol=0.0;
        
        for (int aux=0; aux<NumPatterns; aux++){
            
            double deg_check=0;
            
            for (int aux2=0; aux2<nv*Nchains;aux2++)
                deg_check=deg_check+T[aux2*NumPatterns+aux];
            
            check_evol=check_evol+deg_check*DeltaCheck[aux];
            
        }
        
        //mexPrintf("check_evol=%f\n",check_evol);
        
        int end_flag=0;
        
        //Storing the DD
        
        for(int i=0;i<NumPatterns;i++)
        {
            RPD[iteration*NumPatterns+i]=RPD[(iteration-1)*NumPatterns+i]+DeltaCheck[i]/norm_time;
            if(RPD[iteration*NumPatterns+i]<0)
                end_flag=1;
        }
        
        for (int i=0;i<nv*Nchains;i++)
        {
            VPD[iteration*nv*Nchains+i]=VPD[(iteration-1)*nv*Nchains+i]+DeltaVar[i]/norm_time;
            if(VPD[iteration*nv+i]<0)
                end_flag=1;
        }
        
        //Computing the Variance approximation and cleaning the probabilities vector
        
        
        
        
        double corr=0;
        double m=0;
        
        for (int i=0;i<dimPD1;i++){
            corr=corr+SD1[i]*SD1[i]*PD1[i];
            m=m+SD1[i]*PD1[i];
        }
        
        VAR[iteration]=corr-m*m;
        MEAN[iteration]=m;
        
        for (int i=0;i<dimPD1;i++)
            PD1[i]=0;
        
        //Stopping rule
        
        sumD=0;
        sumV=0;
        
        for(int i=0;i<NumPatterns;i++)
        {
            if(D[i]==1)
                sumD=sumD+RPD[iteration*NumPatterns+i];
        }
        
        if(sumD<0.00000001)
            break;
        
        if(end_flag==1)
            break;
        
        (*it_counter)=(*it_counter)+1;
        
        
    }
    
    //printf("Scheduled iterations: %d, actual iterations: %d\n",NumIt, *it_counter);
    printf("sumD=%f\n",sumD);
    
    //Free reserved memory
    
    mxDestroyArray(mxProbsPD);
    mxDestroyArray(mxDeltaCheck);
    mxDestroyArray(mxDeltaVar);
    mxFree(checks_mod);
    mxDestroyArray(mxProbsCheck);
    mxDestroyArray(mxsubT);
    mxDestroyArray(mxPD1);
}





