function [pat_not_decodable,num_not_decodable] = obtain_decodable_erasure_patterns(file,deg)

load(file)

[nr,n]=size(G);

R=nr/n;

inf_words=de2bi(0:(2^(R*n)-1),R*n);

Xwords=zeros(2^(R*n),n);

for m=1:1:2^(R*n)
    
    Xwords(m,:)=mod(inf_words(m,:)*G,2);
    
end;


num_pat=nchoosek(n,deg);

%pat=nchoosek(1:n,deg);

pat_dual=nchoosek(1:n,n-deg);

pat=[];  %Only to store non-decodable

decod=ones(num_pat,1);

for p=1:1:num_pat
    
    aux=Xwords(:,pat_dual(p,:));
    
    [a,b]=size(aux);
    
    [c,d]=size(unique(aux,'rows'));
    
    if (a~=c)
        pat=[pat;find(ismember(1:n,pat_dual(p,:))==0)];
        decod(p)=0;
    end;
    
end;

sentence=(['There are ' num2str(sum(decod==0)) ' non-decodable erasure patterns of degree '  num2str(deg) '\n']);

fprintf(sentence);

sentence=(['There are ' num2str(sum(decod==1)) ' decodable erasure patterns of degree '  num2str(deg) '\n']);

fprintf(sentence);

pat_not_decodable=pat;

num_not_decodable=sum(decod==0);