% Differential equation method to track all types of edges in LDPC
% residual graphs during the peeling decoding process
% (3, 6) LDPC as an example, can be extend to varity degree distributions
% and irregular LDPC codes

% parameters
interval      = 10^(-5);
Length_source = 200;
delta         = 0.429;  
vector_var    = [0, 0, 1];           % lambda
vector_che    = [0, 0, 0, 0, 0, 1];  % rho

size_che      = length(vector_che);
size_var      = length(vector_var);

E = 0;
for i = 1 : size_che
    E = E + Length_source * vector_che(1,i) * i;
end

ar = 0;
for i = 1 : size_che
    ar = ar + vector_che(1,i)/i;
end
ar = 1/ar;

al = 0;
for i = 1 : size_var
    al = al + vector_var(1,i)/i;
end
al = 1/al;

tau           = delta/al;
time_num      = round(delta/(al*interval));
el            = zeros(time_num+1,1);
er            = zeros(time_num+1,1);
at            = zeros(time_num+1,1);
li            = zeros(time_num+1,size_var);
rj            = zeros(time_num+1,size_che); 

% compute li(0) based on equation (2)
li(1,:) =  delta * vector_var;

for i = 1 : size_var
    el(1,1) = el(1,1) + li(1,i);
end

for j = 1 : time_num % time
    for i = 1 : size_var
        li(j+1,i) = li(j,i) + interval*(-i*li(j,i)/el(j,1));
    end
    
    for i = 1 : size_var
        el(j+1,1) = el(j+1,1) + li(j+1,i);
    end
end

% compute rj(0) based on equation (5) 
rj_0 = zeros(1,size_che);  
for j = 1 : size_che
    for m = j : size_che
        rj0       = vector_che(1,m) * nchoosek(m-1,j-1) * (delta^j) * (1-delta)^(m-j);
        rj_0(1,j) = rj_0(1,j) + rj0;
    end
end

for i = 1 : size_che
    er(1,1) = er(1,1) + rj_0(1,i);
end

% calculte the expected value of li and rj
rj(1,:) = rj_0;

% define the a and er
for i = 1 : size_var
    at(1,1) = at(1,1) + i*li(1,i)/el(1,1);
end

for j = 1 : time_num
    
    % for edges with right degree one
    rj(j+1,1) = rj(j,1) + interval * ((rj(j,2) - rj(j,1))*(at(j,1)-1)/er(j,1) - 1); 
    
    % for edges with right degree from two to five
    for i = 2 : size_che-1
        rj(j+1,i) = rj(j,i) + interval * ((rj(j,i+1) - rj(j,i))*i*(at(j,1)-1)/er(j,1));
    end
    
    rj(j+1,size_che) =  rj(j,size_che) - interval * (rj(j,size_che)*size_che*(at(j,1)-1)/er(j,1));
    
    for i = 1 : size_che
        er(j+1,1) = er(j+1,1) + rj(j+1,i);
    end
    
    for i = 1 : size_var
        at(j+1,1) = at(j+1,1) + i*li(j+1,i)/el(j+1,1);
    end
end

for i = 1 : time_num
    
    aa = round(er(i,1)/interval);
    bb = round(el(i,1)/interval);
    
    if (aa ~= bb)
        fprintf('Error!! right is %f left is %f, time is %d \n',er(i,1),el(i,1),i);
        break;
    end
    
    if (rj(i,1) <= 0)
        fprintf('No more edge of right degree one after %d iteration, stop! \n',i);
        break;
    end
end

% normalization the time tau

t = interval:interval:tau;
length_pic = size(t);

plot(er,rj(:,1));
grid on;
hold on;
plot(er,rj(:,2));
grid on;
hold on;
plot(er,rj(:,3));
grid on;
hold on;
plot(er,rj(:,4));
grid on;
hold on;
plot(er,rj(:,5));
grid on;
hold on;
plot(er,rj(:,6));
grid on;
hold on;

fprintf('(3, 6) end! \n');

    
    
    
    