%******************************************************************************%
%                                                                              %
%    In our GLDPC design, there are two kinds of check nodes, parity-check     %     
%    nodes and check nodes which can correct up to three errors. We compute the%
%    threshold given the fraction of the generalized check nodes in GLDPC graph%
%                                                                              %
%    Please note this program can be applied on varity of degree distributions,% 
%    and component codes with different minimal distance                       %      
%                                                                              %
%******************************************************************************%

% initialization 
clear all;
close all;
clc;

% parameters
interval       = 10^(-6);   
parameter      = 0.00000001; 
fraction_step  = 0.05;
times          = 1/fraction_step;
dmin           = 3;
epsilon_gene   = zeros(1,times);

for fraction_times = 1 : times   
    fraction_2     = 0;    %fraction_times * fraction_step;
    pd             = 1 ;   % the fraction of three erasure patterns we can correct with minimum distance equal to 3
    pd1            = 0.8 ; % the fraction of four erasure patterns we can correct with minimum distance equal to 3

    % (3,6), 
    threshold       = 0.429;
    vector_var      = [0, 0, 1];             % lambda
    vector_che_p    = [0, 0, 0, 0, 0, 1-fraction_2];    % parity check nodes
    vector_che_c    = [0, 0, 0, 0, 0,   fraction_2];    % generalized check nodes
    
    flag_rp1    = 0;
    flag_rc1    = 0;
    flag_rc2    = 0;
    flag_rc3    = 0;
    flag_rc3_1  = 0;
    flag_break  = 0; 

    size_che      = length(vector_che_p);
    size_var      = length(vector_var);

    flag_gene = 0;
    for delta_epsilon =  0.584: 0.0005 : 0.584          
        epsilon       = 0.999 - delta_epsilon;   
        ending        = 2; 
       
        al = 0;
        for i = 1 : size_var
            al = al + vector_var(1,i)/i;
        end
        al = 1/al;

        time_num      = round(epsilon/(al*interval));
        time_num1     = 4000000;
        el            = zeros(time_num1+1,1);
        er            = zeros(time_num1+1,1);
        at            = zeros(time_num1+1,1);
        li            = zeros(time_num1+1,size_var);
        rcj           = zeros(time_num1+1,size_che +2);
        rpj           = zeros(time_num1+1,size_che);
        Pp1           = zeros(time_num+1,1);
        Pc1           = zeros(time_num+1,1);
        Pc2           = zeros(time_num+1,1);
        Pc3           = zeros(time_num+1,1);
        Pc3_1         = zeros(time_num+1,1);

        % initialization
        rpj_0 = zeros(1,size_che);  
        for j = 1 : size_che
            for m = j : size_che
                rpj0       = vector_che_p(1,m)  * nchoosek(m-1,j-1) * (epsilon^j) * (1-epsilon)^(m-j);
                rpj_0(1,j) = rpj_0(1,j) + rpj0;
            end
        end

        rcj_0 = zeros(1,size_che);  
        for j = 1 : size_che
            for m = j : size_che
                rcj0       = vector_che_c(1,m) * nchoosek(m-1,j-1) * (epsilon^j) * (1-epsilon)^(m-j);
                rcj_0(1,j) = rcj_0(1,j) + rcj0;
            end
        end
        
        for i = 1 : size_che
            er(1,1) = er(1,1) + rcj_0(1,i) + rpj_0(1,i);
        end

        li(1,:) =  epsilon * vector_var;
        for i = 1 : size_var
            el(1,1) = el(1,1) + li(1,i);
        end

        for i = 1 : size_var
            at(1,1) = at(1,1) + i*li(1,i)/el(1,1);
        end

        rpj(1,:)   = rpj_0;   
        for i = 1:size_che
            if (i<dmin)
                rcj(1,i) = rcj_0(1,i);
            elseif (i == dmin)
                rcj(1,i)     = rcj_0(1,i) * pd;         % decodable
                rcj(1,i+1) = rcj_0(1,i) * (1-pd);   % undecodable
            elseif (i == dmin+1)
                rcj(1,i+1) = rcj_0(1,i) * pd1;        % decodable   dmin+1
                rcj(1,i+2) = rcj_0(1,i) * (1-pd1);  % undecodable  dmin+1
            else
                rcj(1,i+2) = rcj_0(1,i);
            end
        end
      
        sum = rpj(1,1);
        for i = 1 : dmin
            sum = sum + rcj(1,i)/i;
        end
        sum = sum + rcj(1,i+2)/(dmin+1);
         
        Pp1(1,1)    =   rpj(1,1)     / sum;
        Pc1(1,1)    =    rcj(1,1)     / sum;
        Pc2(1,1)    = (  rcj(1,2)/2) / sum;
        Pc3(1,1)    = (  rcj(1,3)/3) / sum;  % rcj(1,3) is the decodable dmin erasure patterns, rcj(1,4) is the undecodable dmin erasure patterns.
        Pc3_1(1,1) = (  rcj(1,5)/4) / sum;  % rcj(1,5) is the decodable dmin+1 erasure patterns, rcj(1,6) is the undecodable dmin+1 erasure patterns.
   
        % if sum_rpj = 0, no SPC; if sum_rcj = 0, no GC
        sum_rpj  = 0;
        sum_rcj = 0;
        for i = 1 : size_che
            sum_rpj  = sum_rpj  + vector_che_p(1,i);
            sum_rcj  = sum_rcj + vector_che_c(1,i);
        end
        
        % first iteration 
        for j = 1 :  time_num
            
            if (rpj(j,1) <=  parameter)
                flag_rp1 = 1; % no more spc
            else
                flag_rp1 = 0;
            end  

            if (rcj(j,1) <= parameter)      
                flag_rc1 = 1;
            else
                flag_rc1 = 0;
            end

            if (rcj(j,2) <= parameter)
                flag_rc2 = 1;
            else
                flag_rc2 = 0;
            end  

            if (rcj(j,3) <= parameter)      
                flag_rc3 = 1;
            else
                flag_rc3 = 0;
            end
            
            if (rcj(j,5) <= parameter)      
                flag_rc3_1 = 1;
            else
                flag_rc3_1 = 0;
            end

            if (sum_rpj == 0)
                if (sum_rcj == 0)
                         fprintf('Eeeeerror \n');
                    flag_break = 1000;
                    break;
                else
                    if (flag_rc1 && flag_rc2 && flag_rc3 && flag_rc3_1)
                             fprintf('deg2: %d \n ER = %d \n',j,er(j,1));
                        flag_break = 02;                
                        ending = j;
                        break;
                    end
                end
            else
                if (sum_rcj == 0)
                    if (flag_rp1)
                            fprintf('deg1: %d \n ER = %d \n',j,er(j,1));
                        flag_break = 10;              
                        ending = j;
                        break;
                    end
                else
                    if (flag_rp1 && flag_rc1 && flag_rc2 && flag_rc3 && flag_rc3_1)
                             fprintf('deg1 and deg3: %d \n ER = %d \n',j,er(j,1));
                        flag_break = 12;              
                        ending = j;
                        break;
                    end
               end
            end      
            % parity check 1                                 
                rpj(j+1,1)  = rpj(j,1) +  interval * ( Pp1(j,1)   * ( (rpj(j,2) - rpj(j,1)) * (  at(j,1)-1) / er(j,1) - 1   ) + ...
                                                                  Pc1(j,1)    * ( (rpj(j,2) - rpj(j,1)) * (  at(j,1)-1) / er(j,1)       ) + ...
                                                                  Pc2(j,1)    * ( (rpj(j,2) - rpj(j,1)) * (2*at(j,1)-2) / er(j,1)       ) + ...
                                                                  Pc3(j,1)    * ( (rpj(j,2) - rpj(j,1)) * (3*at(j,1)-3) / er(j,1)       ) + ...
                                                                  Pc3_1(j,1) * ( (rpj(j,2) - rpj(j,1)) * (4*at(j,1)-4) / er(j,1)       ) );    

                rpj(j+1,2)  = rpj(j,2) +  interval * ( Pp1(j,1)   * ( (rpj(j,3) - rpj(j,2))*2* (  at(j,1)-1) / er(j,1)       ) + ...
                                                                  Pc1(j,1)    * ( (rpj(j,3) - rpj(j,2))*2* (  at(j,1)-1) / er(j,1)       ) + ...
                                                                  Pc2(j,1)    * ( (rpj(j,3) - rpj(j,2))*2* (2*at(j,1)-2) / er(j,1)       ) + ...       
                                                                  Pc3(j,1)     * ( (rpj(j,3) - rpj(j,2))*2* (3*at(j,1)-3) / er(j,1)       ) + ...
                                                                  Pc3_1(j,1) * ( (rpj(j,3) - rpj(j,2)) *2* (4*at(j,1)-4) / er(j,1)       ) );    

                rpj(j+1,3)  = rpj(j,3) +  interval * ( Pp1(j,1)  * ( (rpj(j,4) - rpj(j,3))*3*(  at(j,1)-1) / er(j,1)       ) + ...
                                                                  Pc1(j,1)    * ( (rpj(j,4) - rpj(j,3))*3*(  at(j,1)-1) / er(j,1)       ) + ...
                                                                  Pc2(j,1)    * ( (rpj(j,4) - rpj(j,3))*3*(2*at(j,1)-2) / er(j,1)       ) + ...       
                                                                  Pc3(j,1)    * ( (rpj(j,4) - rpj(j,3))*3*(3*at(j,1)-3) / er(j,1)       ) + ...
                                                                  Pc3_1(j,1) * ( (rpj(j,4) - rpj(j,3))*3*(4*at(j,1)-4) / er(j,1)       ) );   

                rpj(j+1,4)  = rpj(j,4) +  interval * ( Pp1(j,1)   * ( (rpj(j,5) - rpj(j,4))*4*(  at(j,1)-1) / er(j,1)       ) + ...
                                                                    Pc1(j,1)  * ( (rpj(j,5) - rpj(j,4))*4*(  at(j,1)-1) / er(j,1)       ) + ...
                                                                    Pc2(j,1)  * ( (rpj(j,5) - rpj(j,4))*4*(2*at(j,1)-2) / er(j,1)       ) + ...       
                                                                    Pc3(j,1)  * ( (rpj(j,5) - rpj(j,4))*4*(3*at(j,1)-3) / er(j,1)       ) + ...
                                                                  Pc3_1(j,1) * ( (rpj(j,5) - rpj(j,4))*4*(4*at(j,1)-4) / er(j,1)       ) );  
                                                              
             % generalized
                rcj(j+1,1) = rcj(j,1) + interval * (   Pp1(j,1)    * ( (rcj(j,2) - rcj(j,1)) * (  at(j,1)-1) / er(j,1)     ) + ...
                                                                  Pc1(j,1)    * ( (rcj(j,2) - rcj(j,1)) * (  at(j,1)-1) / er(j,1) - 1 ) + ...
                                                                  Pc2(j,1)    * ( (rcj(j,2) - rcj(j,1)) * (2*at(j,1)-2) / er(j,1)     ) + ...
                                                                  Pc3(j,1)    * ( (rcj(j,2) - rcj(j,1)) * (3*at(j,1)-3) / er(j,1)     ) + ...
                                                                  Pc3_1(j,1) * ( (rcj(j,2) - rcj(j,1)) * (4*at(j,1)-4) / er(j,1)     ) );

                rcj(j+1,2) = rcj(j,2) + interval * (   Pp1(j,1)   * ( (rcj(j,3) + rcj(j,4)  - rcj(j,2))*2*(  at(j,1)-1) / er(j,1)     ) + ...
                                                                  Pc1(j,1)    * ( (rcj(j,3) + rcj(j,4)  - rcj(j,2))*2*(  at(j,1)-1) / er(j,1)     ) + ...
                                                                  Pc2(j,1)    * ( (rcj(j,3) + rcj(j,4)  - rcj(j,2))*2*(2*at(j,1)-2) / er(j,1) - 2) + ...
                                                                  Pc3(j,1)    * ( (rcj(j,3) + rcj(j,4)  - rcj(j,2))*2*(3*at(j,1)-3) / er(j,1)     ) + ...
                                                                  Pc3_1(j,1) * ( (rcj(j,3) + rcj(j,4)  - rcj(j,2))*2*(4*at(j,1)-4) / er(j,1)     ) ); 
              % decodable dmin 3
              rcj(j+1,3) = rcj(j,3) + interval * (  Pp1(j,1)    *  (pd * rcj(j,6)+ rcj(j,5) - rcj(j,3)) *3* (   at(j,1)-1) / er(j,1)      + ...
                                                               Pc1(j,1)    *  (pd * rcj(j,6)+ rcj(j,5) - rcj(j,3)) *3* (   at(j,1)-1) / er(j,1)      + ...
                                                               Pc2(j,1)    *  (pd * rcj(j,6)+ rcj(j,5) - rcj(j,3)) *3* (2*at(j,1)-2) / er(j,1)      + ...
                                                               Pc3(j,1)    * ((pd * rcj(j,6)+ rcj(j,5) - rcj(j,3)) *3* (3*at(j,1)-3) / er(j,1) -3) + ...
                                                               Pc3_1(j,1) *  (pd * rcj(j,6)+ rcj(j,5) - rcj(j,3)) *3* (4*at(j,1)-4) / er(j,1) );      
              % undecodable dmin 3                                            
              rcj(j+1,4) = rcj(j,4) + interval * (  Pp1(j,1)    *  ((1-pd) * rcj(j,6) - rcj(j,4)) *3* (   at(j,1)-1) / er(j,1) + ...
                                                               Pc1(j,1)    *  ((1-pd) * rcj(j,6) - rcj(j,4)) *3* (   at(j,1)-1) / er(j,1)  + ...
                                                               Pc2(j,1)    *  ((1-pd) * rcj(j,6) - rcj(j,4)) *3* (2*at(j,1)-2) / er(j,1) + ...
                                                               Pc3(j,1)    *  ((1-pd) * rcj(j,6) - rcj(j,4)) *3* (3*at(j,1)-3) / er(j,1) + ...
                                                               Pc3_1(j,1) *  ((1-pd) * rcj(j,6) - rcj(j,4)) *3* (4*at(j,1)-4) / er(j,1) ); 
                                                           
%               rcj(j+1,3) = rcj(j,3) + interval * (     pd * ( Pp1(j,1)    * (    (rcj(j,5) + rcj(j,6)) *3*(  at(j,1)-1) / er(j,1)      )   + ...
%                                                                            Pc1(j,1)    * (    (rcj(j,5) + rcj(j,6)) *3*(  at(j,1)-1) / er(j,1)      )   + ...
%                                                                            Pc2(j,1)    * (    (rcj(j,5) + rcj(j,6)) *3*(2*at(j,1)-2) / er(j,1)     )   + ...
%                                                                            Pc3(j,1)    * (    (rcj(j,5) + rcj(j,6)) *3*(3*at(j,1)-3) / er(j,1)     ) + ...
%                                                                            Pc3_1(j,1) * (    (rcj(j,5) + rcj(j,6)) *3*(4*at(j,1)-4) / er(j,1)     ) ) + ...
%                                                                            Pp1(j,1)     * ( - rcj(j,3) *3*(  at(j,1)-1) / er(j,1)        ) + ...
%                                                                            Pc1(j,1)     * ( - rcj(j,3) *3*(  at(j,1)-1) / er(j,1)        ) + ...
%                                                                            Pc2(j,1)     * ( - rcj(j,3) *3*(2*at(j,1)-2) / er(j,1)       ) + ...
%                                                                            Pc3(j,1)     * ( - rcj(j,3) *3*(3*at(j,1)-3) / er(j,1) - 3  ) + ...
%                                                                            Pc3_1(j,1) * ( - rcj(j,3) *3*(4*at(j,1)-4) / er(j,1)        )  );   
%              % undecodable dmin 3
%               rcj(j+1,4) = rcj(j,4) + interval * ((1-pd) * ( Pp1(j,1)    * (    (rcj(j,5) + rcj(j,6)) *3*(  at(j,1)-1) / er(j,1)      )   + ...
%                                                                            Pc1(j,1)    * (    (rcj(j,5) + rcj(j,6)) *3*(  at(j,1)-1) / er(j,1)      )   + ...
%                                                                            Pc2(j,1)    * (    (rcj(j,5) + rcj(j,6)) *3*(2*at(j,1)-2) / er(j,1)     )   + ...
%                                                                            Pc3(j,1)    * (    (rcj(j,5) + rcj(j,6)) *3*(3*at(j,1)-3) / er(j,1)     ) + ...
%                                                                            Pc3_1(j,1) * (    (rcj(j,5) + rcj(j,6)) *3*(4*at(j,1)-4) / er(j,1)     ) ) + ...
%                                                                            Pp1(j,1)     * ( - rcj(j,4) *3*(  at(j,1)-1) / er(j,1)        ) + ...
%                                                                            Pc1(j,1)     * ( - rcj(j,4) *3*(  at(j,1)-1) / er(j,1)        ) + ...
%                                                                            Pc2(j,1)     * ( - rcj(j,4) *3*(2*at(j,1)-2) / er(j,1)       ) + ...
%                                                                            Pc3(j,1)     * ( - rcj(j,4) *3*(3*at(j,1)-3) / er(j,1)      ) + ...
%                                                                            Pc3_1(j,1) * ( - rcj(j,4) *3*(4*at(j,1)-4) / er(j,1)        )  );     
              % decodable dmin+1 4
              rcj(j+1,5) = rcj(j,5) + interval * ( pd1 * ( Pp1(j,1)    * (    rcj(j,7) *4*(  at(j,1)-1) / er(j,1)      )   + ...
                                                                           Pc1(j,1)    * (    rcj(j,7) *4*(  at(j,1)-1) / er(j,1)      )   + ...
                                                                           Pc2(j,1)    * (    rcj(j,7) *4*(2*at(j,1)-2) / er(j,1)     )   + ...
                                                                           Pc3(j,1)    * (    rcj(j,7) *4*(3*at(j,1)-3) / er(j,1)     ) + ...
                                                                           Pc3_1(j,1) * (    rcj(j,7) *4*(4*at(j,1)-4) / er(j,1)     ) ) + ...
                                                                           Pp1(j,1)     * ( - rcj(j,5) *4*(  at(j,1)-1) / er(j,1)        ) + ...
                                                                           Pc1(j,1)     * ( - rcj(j,5) *4*(  at(j,1)-1) / er(j,1)        ) + ...
                                                                           Pc2(j,1)     * ( - rcj(j,5) *4*(2*at(j,1)-2) / er(j,1)       ) + ...
                                                                           Pc3(j,1)     * ( - rcj(j,5) *4*(3*at(j,1)-3) / er(j,1)       ) + ...
                                                                           Pc3_1(j,1) * ( - rcj(j,5) *4*(4*at(j,1)-4) / er(j,1)  - 4  )  );   
             % undecodable dmin+1 4
              rcj(j+1,6) = rcj(j,6) + interval * ((1-pd1) * ( Pp1(j,1)  * (   rcj(j,7) *4*(  at(j,1)-1) / er(j,1)      )   + ...
                                                                              Pc1(j,1)    * (   rcj(j,7) *4*(  at(j,1)-1) / er(j,1)      )   + ...
                                                                              Pc2(j,1)    * (   rcj(j,7) *4*(2*at(j,1)-2) / er(j,1)     )   + ...
                                                                              Pc3(j,1)    * (   rcj(j,7) *4*(3*at(j,1)-3) / er(j,1)     ) + ...
                                                                              Pc3_1(j,1) * (   rcj(j,7) *4*(4*at(j,1)-4) / er(j,1)     ) ) + ...
                                                                            Pp1(j,1)     * ( - rcj(j,6) *4*(  at(j,1)-1) / er(j,1)        ) + ...
                                                                            Pc1(j,1)     * ( - rcj(j,6) *4*(  at(j,1)-1) / er(j,1)        ) + ...
                                                                            Pc2(j,1)     * ( - rcj(j,6) *4*(2*at(j,1)-2) / er(j,1)       ) + ...
                                                                            Pc3(j,1)     * ( - rcj(j,6) *4*(3*at(j,1)-3) / er(j,1)      ) + ...
                                                                            Pc3_1(j,1) * ( - rcj(j,6) *4*(4*at(j,1)-4) / er(j,1)        )  );                                      

                % for edges with right degree from two to five
                if (size_che >=6)
                   for i = dmin+2 : size_che-1
                        rcj(j+1,i+2) = rcj(j,i+2) + interval * (Pp1(j,1)     * ( (rcj(j,i+3) - rcj(j,i+2))*i*(  at(j,1)-1) / er(j,1) ) + ...
                                                                             Pc1(j,1)    *   ( (rcj(j,i+3) - rcj(j,i+2))*i*(  at(j,1)-1) / er(j,1) ) + ...
                                                                             Pc2(j,1)    *   ( (rcj(j,i+3) - rcj(j,i+2))*i*(2*at(j,1)-2) / er(j,1) ) + ...
                                                                             Pc3(j,1)    *   ( (rcj(j,i+3) - rcj(j,i+2))*i*(3*at(j,1)-3) / er(j,1) ) + ...
                                                                             Pc3_1(j,1) *   ( (rcj(j,i+3) - rcj(j,i+2))*i*(4*at(j,1)-4) / er(j,1) ) );

                        rpj(j+1,i)  = rpj(j,i)  + interval * (Pp1(j,1)    * (  (rpj(j,i+1) - rpj(j,i))*i*(  at(j,1)-1)  / er(j,1) ) + ...
                                                                        Pc1(j,1)    * (  (rpj(j,i+1) - rpj(j,i))*i*(  at(j,1)-1)  / er(j,1) ) + ...
                                                                        Pc2(j,1)    * (  (rpj(j,i+1) - rpj(j,i))*i*(2*at(j,1)-2)  / er(j,1) ) + ...
                                                                        Pc3(j,1)    * (  (rpj(j,i+1) - rpj(j,i))*i*(3*at(j,1)-3)  / er(j,1) )+ ...
                                                                        Pc3_1(j,1) * (  (rpj(j,i+1) - rpj(j,i))*i*(4*at(j,1)-4)  / er(j,1) ) );    
                   end 
                end

                % for the edges with the max right degree      
                rcj(j+1,size_che+2) = rcj(j,size_che+2) - interval * ( Pp1(j,1)   * ( rcj(j,size_che+2)*size_che*(  at(j,1)-1) / er(j,1) ) + ... 
                                                                                             Pc1(j,1)    * ( rcj(j,size_che+2)*size_che*(  at(j,1)-1) / er(j,1) ) + ...
                                                                                             Pc2(j,1)    * ( rcj(j,size_che+2)*size_che*(2*at(j,1)-2) / er(j,1) ) + ... 
                                                                                             Pc3(j,1)    * ( rcj(j,size_che+2)*size_che*(3*at(j,1)-3) / er(j,1) ) + ... 
                                                                                             Pc3_1(j,1) * ( rcj(j,size_che+2)*size_che*(4*at(j,1)-4) / er(j,1) ) ); 

                rpj(j+1,size_che)  = rpj(j,size_che)  - interval * (Pp1(j,1)    * ( rpj(j,size_che)*size_che*(  at(j,1)-1 ) / er(j,1) ) + ... 
                                                                                      Pc1(j,1)    * ( rpj(j,size_che)*size_che*(  at(j,1)-1 ) / er(j,1) ) + ...
                                                                                      Pc2(j,1)    * ( rpj(j,size_che)*size_che*(2*at(j,1)-2) / er(j,1) ) + ... 
                                                                                      Pc3(j,1)    * ( rpj(j,size_che)*size_che*(3*at(j,1)-3) / er(j,1) ) + ... 
                                                                                      Pc3_1(j,1) * ( rpj(j,size_che)*size_che*(4*at(j,1)-4) / er(j,1) ) );                                                                               


                for i = 1 : size_che
                    er(j+1,1) = er(j+1,1) + rcj(j+1,i) + rpj(j+1,i);
                end
                    er(j+1,1) = er(j+1,1) + rcj(j+1,size_che+1) + rcj(j+1,size_che+2);

                for i = 1 : size_var                                                                                
                    li(j+1,i) = li(j,i) + interval * (-(4*Pc3_1(j,1) + 3*Pc3(j,1) + 2*Pc2(j,1) + Pc1(j,1) + Pp1(j,1)) *i*li(j,i)/el(j,1));
                end

                for i = 1 : size_var                                                                                
                    el(j+1,1) = el(j+1,1) + li(j+1,i);
                end

                for i = 1 : size_var                                                                                
                    at(j+1,1) = at(j+1,1) + i*li(j+1,i)/el(j+1,1);
                end

                % break conditions
                diff = er(j+1,1) - el(j+1,1);
                if ((er(j+1,1) <= parameter) || (el(j+1,1) <= parameter))
                    ending = j;
                    break;
                end
                if ((diff > 0.0001)||(diff < -0.0001))
                    ending = j;
                    break;
                end 

                sum_nxt = rpj(j+1,1);
                for i = 1 : dmin
                    sum_nxt = sum_nxt + rcj(j+1,i)/i;
                end
                sum_nxt = sum_nxt + rcj(j+1,i+2)/(dmin+1);
                
                Pp1(j+1,1)    =   rpj(j+1,1)     / sum_nxt;
                Pc1(j+1,1)    =    rcj(j+1,1)     / sum_nxt;
                Pc2(j+1,1)    = (  rcj(j+1,2)/2) / sum_nxt;
                Pc3(j+1,1)    = (  rcj(j+1,3)/3) / sum_nxt;
                Pc3_1(j+1,1) = (  rcj(j+1,5)/4) / sum_nxt;

                if (rpj(j+1,1)  < parameter)
                    rpj(j+1,1)  = rpj(j,1);
                    Pp1(j+1,1)  = 0;
                end            
                if (rcj(j+1,1) < parameter)
                    rcj(j+1,1)  = rcj(j,1);
                    Pc1(j+1,1) = 0;
                end            
                if (rcj(j+1,2) < parameter)
                    rcj(j+1,2)  = rcj(j,2);
                    Pc2(j+1,1) = 0;
                end            
                if (rcj(j+1,3) < parameter)
                    rcj(j+1,3)  = rcj(j,3);
                    Pc3(j+1,1) = 0;
                end       
                if (rcj(j+1,5) < parameter)
                    rcj(j+1,5)  = rcj(j,5);
                    Pc3_1(j+1,1) = 0;
                end        
        end 
         
        if ((el(ending,1) > 0) && (el(ending,1) < 0.0001))
            epsilon_gene(1,fraction_times) = epsilon;
            break;
        end 
    end
end
fprintf('End! \n');

figure(1);
h_5 = semilogy(er,rpj(:,1),'-k', er,rcj(:,1),'-g', er,rcj(:,2),'--g', er,rcj(:,3),'-.g', er,rcj(:,5),'-*g', er,rpj(:,1)+rcj(:,1)+rcj(:,2)+rcj(:,3) +rcj(:,5),'b-');          
for i = 1 : 6
    set(h_5(i),'linewidth',2);
end
grid on;
hold on;











