
function G27 = BEC_GPD_TOP(Pe,Fraction_v,Fraction_p, Fraction_p1, Dmin)

    Iter_max                = 50;
    Rho_frac                = [Fraction_v Fraction_p Fraction_p1 0 0];
    Baseloop                = 1000000; %10000;
    number_matrix           = 1; %50;
    Rate                    = 1-2/7;      

    folder=['/Users/GLDPC/DECODER/BEC/FINITE_LENGTH_data/27_QC_469'];

    if(exist(folder,'dir')~=7)
        mkdir(folder);
    end

    for i = 1 : 1 %number_codelength :  number_codelength
        strH=(['QC_27_469.mat']); 
        load(strH);
        [rows, ~]  = size(Matrix_QC_27);
        rows       = rows/number_matrix;
        for j = 1 : 1 %number_matrix   
           % fprintf('Matrix: %d\n',j);
            matrix   = Matrix_QC_27((j-1)*rows+1 : j*rows, :);
            G27     = BEC_GPD(Pe, Iter_max, Rho_frac, Baseloop, matrix, Rate, Dmin); 
            savefile = ([ folder  '/G27both'  '_Pe_' num2str(round(Pe*1000)) '_d2_' num2str(round(Fraction_v*100)) ...
                          '_d3_' num2str(round(Fraction_p*10))  '_le_'  num2str(i) '_index_' num2str(j) '_d_' num2str(Dmin)  '.mat']);
            save(savefile, 'G27','Pe','Fraction_v','Fraction_p','i','j','Dmin');
        end
    end

end


