#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

typedef uint16_t char16_t;

#include <mex.h>
#include "matrix.h"

#ifdef Debug_
#notdefine Debug_
#endif

int  compare(int *v1, double *v2, int n_cols, int n_rows_unde, int d_min); 
void BEC_trans(int * messandflag, int code_length, int num_gene, int rows, int d_min, double epsilon);
void BD_PD_decoder(double *p_ber, int code_length, int max_iter, int d_min, int *messageandflag, int R_gene, int rows, int columns, int row_unde, int row_unde1, double *matrix_add, double *p_matrix_gene, double *p_matrix_unde, double *p_matrix_unde1, double frac, double frac1, int loop, int fail_loop);
void GLDPC_Dec_BEC(double *p_output, double *p_parameters, double *matrix_add, double *p_matrix_gene, double *p_matrix_unde, double *p_matrix_unde1, int mrows, int ncols, int row_unde, int row_unde1);

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    double *p_parameters;
    double *matrix_add, *p_matrix_gene, *p_matrix_unde, *p_matrix_unde1;
    double *p_output;
    int     mrows, ncols, mrows_gene, ncols_gene, mrows_unde, ncols_unde, mrows_unde1, ncols_unde1, i, j;
    
    p_parameters     = mxGetPr(prhs[0]);
    matrix_add       = mxGetPr(prhs[1]);
    mrows            = mxGetM(prhs[1]);
    ncols            = mxGetN(prhs[1]);
    
    p_matrix_gene    = mxGetPr(prhs[2]);
    mrows_gene       = mxGetM(prhs[2]);
    ncols_gene       = mxGetN(prhs[2]);
    p_matrix_unde    = mxGetPr(prhs[3]);
    mrows_unde       = mxGetM(prhs[3]);
    ncols_unde       = mxGetN(prhs[3]);
    p_matrix_unde1   = mxGetPr(prhs[4]);
    mrows_unde1      = mxGetM(prhs[4]);
    ncols_unde1      = mxGetN(prhs[4]); 
    
    plhs[0]   = mxCreateDoubleMatrix(1, 2, mxREAL);
    p_output  = mxGetPr(plhs[0]);
    
    GLDPC_Dec_BEC(p_output, p_parameters, matrix_add, p_matrix_gene, p_matrix_unde, p_matrix_unde1, mrows, ncols, mrows_unde, mrows_unde1);
}

void GLDPC_Dec_BEC(double *p_output, double *p_parameters, double *matrix_add, double *p_matrix_gene, double *p_matrix_unde, double *p_matrix_unde1, int mrows, int ncols, int row_unde, int row_unde1)
{
    const int        CODE_LENGTH  = *(p_parameters);
    const int        MAX_ITER     = *(p_parameters+1);
    const int        BASELOOP     = *(p_parameters+2);
    const double     EPSILON      = *(p_parameters+3);
    const int        K_GENE2      = *(p_parameters+4);
    const double     F_FRAC       = *(p_parameters+5);
    const double     F_FRAC1      = *(p_parameters+6);
    const int        Dmin         = *(p_parameters+9);
    
    int  *p_messandflag;
    int  i, n_mes, n_baseloop, siz_msf;
    int  n_fail_loop;   
    double d_temp0, d_temp1;
    
    siz_msf = CODE_LENGTH + mrows + K_GENE2*2; 
    p_messandflag = (int*)calloc(siz_msf, sizeof(int));
    
    d_temp0 = 0;
    d_temp1 = 0;
    n_fail_loop = 0;
    
    for (n_baseloop=0; n_baseloop < BASELOOP; n_baseloop++)
    {             
        BEC_trans(p_messandflag, CODE_LENGTH, K_GENE2, mrows, Dmin, EPSILON);
        BD_PD_decoder(p_output, CODE_LENGTH, MAX_ITER, Dmin, p_messandflag, K_GENE2, mrows, ncols, row_unde, row_unde1, matrix_add, p_matrix_gene, p_matrix_unde, p_matrix_unde1, F_FRAC, F_FRAC1, n_baseloop, n_fail_loop);
        
        n_fail_loop = *(p_output+1);
        
        d_temp0 = d_temp0 + *(p_output);
    
        if ( *(p_output) !=0 )
        {
            d_temp1 = d_temp1 + 1;
        }       
    }
    
    *(p_output)   =  (double)d_temp0/BASELOOP;
    *(p_output+1) =  (double)d_temp1/BASELOOP;
   
    free(p_messandflag); 
}

void BEC_trans(int *messandflag, int code_length,  int num_gene, int rows, int d_min, double epsilon)
{ 
    double     temp[code_length];
    int        rand_array[code_length];
    int        array2[num_gene];
    int        i, j, m, temp0, randomIndex, rnd;
    time_t     t;
    
    for (i = 0; i < code_length; i++)
    {
        temp[i] = rand()/(double)RAND_MAX;
        if(temp[i] <= epsilon)
        {
            *(messandflag + i) = 1;
        }
        else
        {            
            *(messandflag + i) = 0;
        }
        
        rand_array[i] = 0;

        if (i<rows)
        {
            *(messandflag + i + code_length) = 1;
        } 
    }

    i = 0;
    while(i<num_gene) 
    {
        rnd = rand() % rows + 1;
        if ( rand_array[rnd-1] == 0 )
        {
            array2[i++] = rnd;
            rand_array[rnd-1] = 1;
        }
    } 

    j = 0;
    m = code_length + rows + num_gene;
    for (i=0; i<num_gene; i++)
    {
        j = array2[i];
        *(messandflag + j + code_length - 1) = d_min-1;  
        *(messandflag + i + code_length + rows) = j - 1;
        *(messandflag + i + m) = i;
    }   
  
    for (int i = 0; i < num_gene; i++) 
    {  
        temp0                            = *(messandflag + i + m);
        randomIndex                      = rand() % num_gene;
        *(messandflag + i + m)           = *(messandflag + randomIndex + m);
        *(messandflag + randomIndex + m) = temp0;
    }               
}

void BD_PD_decoder(double *p_ber, int code_length, int max_iter, int d_min, int *messageandflag, int R_gene, int rows, int columns, int row_unde, int row_unde1, double *matrix_add, double *p_matrix_gene, double *p_matrix_unde, double *p_matrix_unde1, double frac, double frac1, int loop, int fail_loop)
{
    int       p_err_posi[columns];
    int       flag_erasure[columns];
    int       temp_err[d_min];    
    double    f_dmin, f_dmin1;
    int       n_iter, n_error_bit, n_error_row, n_position;
    int       i, j, m, n, temp, n_rows, n_cols, flag_eq; 
    
    for (n_iter = 0; n_iter < max_iter; n_iter++)
    {      
        for (n_rows = 0; n_rows < rows; n_rows++)  
        {            
            for (n_cols=0; n_cols< columns; n_cols++)
            {
                flag_erasure[n_cols] = 0;
            }
            n_error_row  = 0;
            
            for (n_cols = 0; n_cols < columns; n_cols++)
            {
                n_position = *(matrix_add + n_rows +n_cols*rows);
                
                if ( *(messageandflag + n_position  -1) == 1)
                {  
                    p_err_posi[n_error_row] = n_position;
                    n_error_row = n_error_row + 1;
                    flag_erasure[n_cols] = 1; 
                }
            }            
   
            // hamming decoder
            if (n_error_row == 1)
            {
                *(messageandflag + p_err_posi[0]  -1) = 0;
            }
            else if ((n_error_row < d_min) && (n_error_row > 1))
            {
                if (*(messageandflag + code_length + n_rows) > 1)
                {
                    for (n=0; n<n_error_row; n++)
                    {
                        *(messageandflag + p_err_posi[n] -1) = 0;
                    }
                }
            }
            else if (n_error_row == d_min)
            {                
                if ((*(messageandflag + code_length + n_rows) == d_min-1) || (*(messageandflag + code_length + n_rows) == d_min) )
                {
                    
                    for (i=0; i<R_gene; i++)
                    {
                        if (*(messageandflag + i + code_length + rows ) == n_rows)
                        {
                            temp  = *(messageandflag + i + code_length + rows + R_gene);  
                    //       mexPrintf("temp %d n_rows %d ", temp, n_rows);
                        }
                    }
                    
                    #ifdef Debug_ 
                    mexPrintf("flag_erasure \n");
                    for (m=0; m<columns; m++)
                    {                          
                        mexPrintf("%d ", flag_erasure[m]);
                     } 
                    mexPrintf("\n");
                   #endif
                    
                    for (m=0; m<columns; m++)
                    {
                        // flag_erasure is like [0 1 0 1 1 0 ], where 1 means erasure
                        temp_err[m] = flag_erasure[m] * (*(p_matrix_gene+ temp + m*R_gene));                               
                        #ifdef Debug_
                        mexPrintf("%d ", temp_err[m]);
                        #endif
                     } 
                    //     mexPrintf("\n");
                    flag_eq = compare(temp_err, p_matrix_unde, columns, row_unde, d_min);
                        
                    if (flag_eq == 0)
                    {
                        for (n=0; n<n_error_row; n++)
                        {
                            *(messageandflag + p_err_posi[n] -1) = 0;
                        }
                    }
                    else
                    {
                         *(messageandflag + code_length + n_rows) = d_min +1;
                    }
                }
            } 
            else if (n_error_row == d_min+1)
            {                
                if ((*(messageandflag + code_length + n_rows) == d_min-1) && (frac1!=0))
                {
                    
                    for (i=0; i<R_gene; i++)
                    {
                        if (*(messageandflag + i + code_length + rows ) == n_rows)
                        {
                            temp  = *(messageandflag + i + code_length + rows + R_gene);  
                    //       mexPrintf("temp %d n_rows %d ", temp, n_rows);
                        }
                    }
                    
                    #ifdef Debug_ 
                    mexPrintf("flag_erasure \n");
                    for (m=0; m<columns; m++)
                    {                          
                        mexPrintf("%d ", flag_erasure[m]);
                     } 
                    mexPrintf("\n");
                   #endif
                    
                    for (m=0; m<columns; m++)
                    {
                        // flag_erasure is like [0 1 0 1 1 0 ], where 1 means erasure
                        temp_err[m] = flag_erasure[m] * (*(p_matrix_gene+ temp + m*R_gene));                               
                        #ifdef Debug_
                        mexPrintf("%d ", temp_err[m]);
                        #endif
                     } 
                    //     mexPrintf("\n");
                     
                    flag_eq = compare(temp_err, p_matrix_unde1, columns, row_unde1, d_min+1);
                        
                    if (flag_eq == 0)
                    {
                        for (n=0; n<n_error_row; n++)
                        {
                            *(messageandflag + p_err_posi[n] -1) = 0;
                        }
                    }
                    else
                    {
                         *(messageandflag + code_length + n_rows) = d_min;
                    }
                }
            }                        
        }
        
        n_error_bit = 0;
        for (i=0; i<code_length; i++)
        {
             n_error_bit = n_error_bit + *(messageandflag+i);
        }
        
        if (n_error_bit == 0)
        {
           break;
        }    
    }
         
    *(p_ber)   = (double)n_error_bit/code_length;
    *(p_ber+1) = (double)fail_loop;
    
}

// compare whether two vectors are same
int compare(int *v1, double *v2, int n_cols, int n_rows_unde, int d_min) 
{  
    int x, y, z, temp, flag_equal, i, j;  
    int convert0, convert1;
    
    for(x=0; x<n_cols; x++)  
    {
        for(y=x+1; y<n_cols; y++) 
        {
            if(v1[x]>v1[y]) 
            { 
                temp=v1[x]; 
                v1[x]=v1[y];
                v1[y]=temp; 
            }
        }
    }
       
    flag_equal = 0;
    
    for (z=0; z<n_rows_unde; z++)
    {
         #ifdef Debug_
         mexPrintf(" %d %f  \n ",v1[n_cols-1], v2[z + n_rows_unde*(d_min-1)]);
         #endif    
         convert0 = (int) v2[z + n_rows_unde*(d_min-1)];
        if (v1[n_cols-1] == convert0)
        {
            for (x=d_min-1; x>0; x--)
            {
                temp = n_cols - (d_min-x) -1;
                convert1 = (int) v2[z + n_rows_unde*(x-1)];
                
                if (v1[temp] == convert1)
                {
                    flag_equal = 1;
                    #ifdef Debug_
                    mexPrintf("v1[temp] %d %d v2[z + n_rows_unde*(x-1)]  %f flag_equal %d \n ", v1[temp], convert1, v2[z + n_rows_unde*(x-1)], flag_equal);
                    #endif
                }
                else
                {
                    flag_equal = 0;  
                    #ifdef Debug_
                    mexPrintf("v1[temp] %d %d v2[z + n_rows_unde*(x-1)]  %f flag_equal %d \n ", v1[temp], convert1, v2[z + n_rows_unde*(x-1)], flag_equal);
                    #endif
                    break;
                }
            }
        }
        
        if (flag_equal == 1)
        {
            break;
        }
    }
    
    return flag_equal;
}



























