function  [Matrix_unde_733, Matrix_unde_734, Matrix_gene, row_gene] = GENE_MATRIX(Row, Column, Rho_frac)
% calculate the amount of gene rows
row_gene    = Row * Rho_frac(1,1);
row_gene    = int64(row_gene);

% generate gene_matrix randomly
Matrix_gene = zeros(row_gene, Column);
     
for i= 1 : row_gene
    Matrix_gene(i,:) = randperm(Column);
end

% (2, 6)
% short(3,6) hamming code as component code, the undecodable look-up table
% can correct 80% three erasure patterns, 0 four erasure patterns
Matrix_unde_633 = [ 3 5 6; 1 2 6; 1 4 5; 2 3 4];
Matrix_unde_634 = [0];
% random code: can correct 80% three erasure patterns, 0 four erasure patterns
% 0  0	0	0	1	1	1	1
% 0	 0	1	1	0	0	1	1
% 0	 0	1	1	1	1	0	0
% 0	 1	0	1	0	1	0	1
% 0	 1	0	1	1	0	1	0
% 0	 1	1	0	0	1	1	0
% Matrix_unde_633 = [3 4 5; 2 3 6; 1 3 5; 1 2 4];
% Matrix_unde_634 = [0];

% (6, 2, 4) random code, dmin =4, can correct 80% four erasure patterns,  0 five erasure patterns
% codewords are:
%     0	 0	1	1
%     0	 0	1	1
%     0	 1	0	1
%     0  1	0	1
%     0  1	1	0
%     0	 1	1	0
Matrix_unde_644 = [ 3 4 5 6; 1 2 5 6; 1 2 3 4];
Matrix_unde_645 = [0];

% (2,7)
% (4,7) hamming code as component code, the undecodable look-up table
% is the columns with weight 3

%      0     1     0     1     1     0     1     0     1     0     1   0     0     1     0     1
%      0     1     1     0     0     1     1     0     1     0     0   1     1     0     0     1
%      0     0     0     0     0     0     0     0     1     1     1   1     1     1     1     1
%      0     1     1     0     1     0     0     1     0     1     1   0     1     0     0     1
%      0     0     0     0     1     1     1     1     0     0     0   0     1     1     1     1
%      0     0     1     1     0     0     1     1     0     0     1   1     0     0     1     1
%      0     1     0     1     0     1     0     1     0     1     0   1     0     1     0     1
%                    .      .      .     .                    .      .                               .                   
%      2 4 6; 1 6 7; 1 4 5; 2 5 7; 1 2 3; 3 4 7; 3 5 6                                  
                     
Matrix_unde_733 = [2 4 6; 1 6 7; 1 4 5; 2 5 7; 1 2 3; 3 4 7; 3 5 6];
Matrix_unde_734 = [0];

% (2, 8)
% (4, 8) hamming code minimal distance is 4, can correct 80% four erasure patterns,  0 five erasure patterns
Matrix_unde_844 = [1 2 4 7; 
                   2 4 6 8; 
                   1 6 7 8; 
                   1 4 5 8; 
                   2 5 7 8; 
                   1 2 5 6; 
                   4 5 6 7; 
                   1 2 3 8; 
                   3 4 7 8; 
                   1 3 4 6; 
                   2 3 6 7; 
                   2 3 4 5; 
                   1 3 5 7; 
                   3 5 6 8];
Matrix_unde_845 = [0];

% % Quasi Cyclic generator matrix:
% G_quasi_84 = [ 1  0  0  1  0  1  0  1;
%                        0  1  1  0  0  1  0  1;
%                        0  1  0  1  1  0  0  1;
%                        0  1  0  1  0  1  1  0];
% codewords: can correct 80% four erasure patterns,  0 five erasure patterns
%      0     1     0     1     0     1     0     1     0     1     0     1     0     1     0     1
%      0     0     1     1     1     1     0     0     1     1     0     0     0     0     1     1
%      0     0     1     1     0     0     1     1     0     0     1     1     0     0     1     1
%      0     1     0     1     1     0     1     0     1     0     1     0     0     1     0     1
%      0     0     0     0     1     1     1     1     0     0     0     0     1     1     1     1
%      0     1     1     0     0     1     1     0     1     0     0     1     1     0     0     1
%      0     0     0     0     0     0     0     0     1     1     1     1     1     1     1     1
%      0     1     1     0     1     0     0     1     0     1     1     0     1     0     0     1
% Matrix_unde_84_0 = [1 4 6 8; 2 3 6 8; 1 2 3 4; 2 4 5 8; 1 2 5 6; 3 4 5 6; 1 3 5 8; 2 4 6 7; 1 2 7 8; 3 4 7 8; 1 3 6 7; 5 6 7 8; 1 4 5 7; 2 3 5 7];

% (8, 3, 4) code: Cyclic_code, dmin is 4, k_avg is 5, p_d 0.9143, p_d1 0.5714:
% codewords: can correct 91.43% four erasure patterns,  57.14% five erasure patterns
%      0     1     0     1     0     1     0     1
%      0     1     1     0     0     1     1     0
%      0     0     1     1     1     1     0     0
%      0     0     0     0     1     1     1     1
%      0     1     0     1     0     1     0     1
%      0     1     1     0     0     1     1     0
%      0     0     1     1     1     1     0     0
%      0     0     0     0     1     1     1     1
Matrix_unde_844_1 = [1 2 5 6; 2 3 6 7; 1 3 5 7; 3 4 7 8; 2 4 6 8; 1 4 5 8];
Matrix_unde_845_1 = [ 1 2 3 5 6; 
                      1 2 4 5 6; 
                      1 2 5 6 7; 
                      1 2 5 6 8; 
                      1 2 3 6 7; 
                      2 3 4 6 7; 2 3 5 6 7; 2 3 6 7 8; 
                      1 2 3 5 7; 1 3 4 5 7; 1 3 5 6 7; 1 3 5 7 8; 
                      1 3 4 7 8; 2 3 4 7 8; 3 4 5 7 8; 3 4 6 7 8; 
                      1 2 4 6 8; 2 3 4 6 8; 2 4 5 6 8; 2 4 6 7 8; 
                      1 2 4 5 8; 1 3 4 5 8; 1 4 5 6 8; 1 4 5 7 8];
%  (8, 2, 5) code: Cordaro-Wagner Code of length 8, dmin is 5, k_avg is 6, p_d is 0.9643, p_d1 is 0.75
% codewords: can correct 96.43% five erasure patterns,  75% five erasure patterns
%      0     1     0     1
%      0     0     1     1
%      0     1     0     1
%      0     1     0     1
%      0     0     1     1
%      0     1     1     0
%      0     1     1     0
%      0     1     1     0
Matrix_unde_855 = [ 2 5 6 7 8; 
                    1 2 3 4 5]; 
Matrix_unde_856 = [ 1 3 4 6 7 8;
                    1 2 5 6 7 8; 
                    2 3 5 6 7 8; 
                    2 4 5 6 7 8; 
                    1 2 3 4 5 6;
                    1 2 3 4 5 7;
                    1 2 3 4 5 8];
                
% (15, 11, 3) code: 
load('Location_15.mat');
Matrix_unde153 = Location_153;
Matrix_unde154 = Location_154;

% load('Nodecodable_215_d3.mat');
% 
% [row3,col3] = size(Nodecodable_dmin);
% [row4,col4] = size(Nodecodable_dminplus1);
% 
% Location_153 = zeros(col3,3);
% 
% for i = 1 : col3
%     m = 1;
%     for j = 1: row3
%         if (Nodecodable_dmin(j,i) ==1)
%             Location_153(i,m) = j;
%             m = m+1;
%         end
%     end
% end
% 
% Location_154 = zeros(col4,4);
% 
% for i = 1 : col4
%     m = 1;
%     for j = 1: row4
%         if (Nodecodable_dminplus1(j,i) ==1)
%             Location_154(i,m) = j;
%             m = m+1;
%         end
%     end
% end






                            
                            