
% [Indi,H_red,I_]=generaH(500,250,3);
% H=zeros(250,500);
% H(I_)=1;





% funcion que genera una matriz de k filas por n columnas con J unos por
% columna y J*n/k unos por fila. Si J*n/k no es un numero entero da un
% fallo, ya que unicamente acepta matrices con el mismo numero de uno por
% filas.
%
% La matriz H que es k*n nunca se calcula para que no ocupe mucho en
% memoria. Se calculas 3 vectores y matrices que tiene la informacion de
% los unos. La unica que se emplea en los programas posteriores es Indi y H_red,
% pero se dan otras 2 porque pueden ser interesantes. 
%
% H_red contiene en cada fila la posicion de los unos en las filas de H.
% Por lo que es una matriz de k*L elementos.
% El vector fila I_ con tiene n*J elementos contine las posiciones de H
% cuando se trata como un vector, es decir, I_=find(H);
% La forma mas sencilla de reconstruir H es de la siguiente forma:
%
%       H=zeros(k,n);
%       H(I_)=1;
%
% Por ultimo el vector Indi contiene las posiciones de los unos de H leidos
% por filas en el vector I. Este vector es el que se emeple en la
% decodificacion optima de los LDPC y los GTC. 
%**************************************************************************
% Function that generates a matrix of k rows and n columns for each J 
% Column and J * n / k for each row. If J * n / k is not an integer gives 
% Failure because only accepts arrays with the same number of one 
% Rows. 
% 
% The matrix H is k * n never estimated to take up not much 
% Memory. Three vectors and matrices having the information is calculate 
% Each. The only one that is used in subsequent programs is Indi and H_red, 
% But other 2 because they can be interesting. 
% 
% H_red in each row contains the position of each in the ranks of H. 
% As is a matrix of k * L elements. 
% I_ The row vector with J elements has n * contine the positions of H 
% When treated as a vector, that is, Ip = find (H); 
% The easiest way to reconstruct H is as follows: 
% 
% H = zeros (k, n); 
% H (I _) = 1; 
% 
% Finally the vector contains Indi positions each H read 
% By rows in the table I. This vector is the one in emeple 
% Optimal decoding of LDPC and GTC.

function [Indi,H_red,I_]=generaH(n,k,J)
L=J*n/k;

H_red=zeros(k,L);
I_=zeros(1,n*J);

v=J*ones(1,n);
for i=1:k
    nP=find(v);
    if(length(nP)<L)
        H_red=-1;
        Indi=-1;
        return
    end
    I=randperm(length(nP));
    v(nP(I(1:L)))=v(nP(I(1:L)))-1;
    
    H_red(i,:)=sort(nP(I(1:L)));
end

for i=1:n
    [n1,n2]=find(H_red==i);
    I_(1+(i-1)*J:i*J)=sort(n1+(i-1)*k);
end

[val,Indi]=sort((I_-k*floor((I_-1)/k)));




